/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.endpoint;

import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.gson.reflect.TypeToken;
import net.opanel.deps.javalin.Javalin;
import net.opanel.deps.javalin.websocket.WsCloseContext;
import net.opanel.deps.javalin.websocket.WsConfig;
import net.opanel.deps.javalin.websocket.WsConnectContext;
import net.opanel.deps.javalin.websocket.WsErrorContext;
import net.opanel.deps.javalin.websocket.WsMessageContext;
import net.opanel.endpoint.Connectable;
import net.opanel.endpoint.Packet;
import net.opanel.web.JwtManager;
import org.eclipse.jetty.websocket.api.Session;

public abstract class BaseEndpoint
implements Connectable {
    protected final Javalin app;
    protected final WsConfig ws;
    protected final OPanel plugin;
    protected final OPanelServer server;
    private final Set<Session> sessions = new CopyOnWriteArraySet<Session>();
    private final ConcurrentHashMap<Session, Set<Consumer<WsMessageContext>>> sessionListeners = new ConcurrentHashMap();

    public BaseEndpoint(Javalin app, WsConfig ws, OPanel plugin) {
        this.app = app;
        this.ws = ws;
        this.plugin = plugin;
        this.server = plugin.getServer();
        this.init();
    }

    private void init() {
        this.ws.onConnect((WsConnectContext ctx) -> {
            Session session = ctx.session;
            this.subscribe(session, "auth", String.class, (msgCtx, token) -> {
                String hashedRealKey = this.plugin.getConfig().accessKey;
                if (token != null && JwtManager.verifyToken(token, hashedRealKey, this.plugin.getConfig().salt)) {
                    this.sessions.add(session);
                    msgCtx.send(new Packet("connect"));
                    this.onConnect((WsMessageContext)msgCtx);
                } else {
                    msgCtx.closeSession(1008, "Unauthorized.");
                }
            });
            this.subscribe(session, "ping", msgCtx -> msgCtx.send(new Packet("pong")));
        });
        this.ws.onMessage(ctx -> {
            if (!this.sessionListeners.containsKey(ctx.session)) {
                return;
            }
            for (Consumer<WsMessageContext> listener : this.sessionListeners.get(ctx.session)) {
                try {
                    listener.accept(ctx);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.ws.onClose((WsCloseContext ctx) -> {
            this.sessions.remove(ctx.session);
            this.onClose(ctx);
        });
        this.app.events(event -> event.serverStopping(this::closeAllSessions));
    }

    protected void subscribe(Session session, String type, Consumer<WsMessageContext> cb) {
        this.subscribe(session, type, Object.class, (ctx, data) -> cb.accept((WsMessageContext)ctx));
    }

    protected <D> void subscribe(Session session, String type, Class<D> dataClass, BiConsumer<WsMessageContext, D> cb) {
        Set listeners = this.sessionListeners.computeIfAbsent(session, k -> new CopyOnWriteArraySet());
        listeners.add(ctx -> {
            if (ctx.session != session) {
                return;
            }
            if (!this.sessions.contains(session) && !type.equals("auth")) {
                ctx.closeSession(1008, "Unauthorized.");
                return;
            }
            Packet packet = ctx.messageAsClass(Packet.class);
            if (packet.type.equals(type)) {
                Type realPacketType = TypeToken.getParameterized(Packet.class, new Type[]{dataClass}).getType();
                Packet resolvedPacket = (Packet)ctx.messageAsClass(realPacketType);
                cb.accept((WsMessageContext)ctx, resolvedPacket.data);
            }
        });
    }

    @Override
    public void onConnect(WsMessageContext ctx) {
    }

    @Override
    public void onClose(WsCloseContext ctx) {
    }

    @Override
    public void onError(WsErrorContext ctx) {
    }

    protected void sendErrorMessage(WsMessageContext ctx, String err) {
        ctx.send(new Packet<String>("error", err));
    }

    protected <D> void broadcast(Packet<D> packet) {
        String message = new Gson().toJson(packet);
        for (Session session : this.sessions) {
            if (!session.isOpen()) {
                this.sessions.remove(session);
                continue;
            }
            try {
                session.getRemote().sendString(message);
            }
            catch (Exception e) {
                System.err.println("[OPanel] Failed to broadcast message to session: " + e.getMessage());
            }
        }
    }

    public void closeAllSessions() {
        for (Session session : this.sessions) {
            if (!session.isOpen()) continue;
            session.close(1000, "Server is stopping.");
        }
        this.sessions.clear();
    }
}

