/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.Context;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.utils.Utils;

public class PlayersController
extends BaseController {
    public Handler getPlayers = ctx -> {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("maxPlayerCount", this.server.getMaxPlayerCount());
        obj.put("whitelist", this.server.isWhitelistEnabled());
        this.sendResponse(ctx, obj);
    };
    public Handler giveOp = ctx -> {
        OPanelPlayer player = this.getTargetPlayer(ctx);
        if (player == null) {
            return;
        }
        player.giveOp();
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler depriveOp = ctx -> {
        OPanelPlayer player = this.getTargetPlayer(ctx);
        if (player == null) {
            return;
        }
        player.depriveOp();
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler kickPlayer = ctx -> {
        OPanelPlayer player = this.getTargetPlayer(ctx);
        if (player == null) {
            return;
        }
        if (!player.isOnline()) {
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "Player is offline.");
            return;
        }
        String reason = ctx.queryParam("r");
        player.kick(reason != null ? Utils.base64ToString(reason) : null);
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler banPlayer = ctx -> {
        OPanelPlayer player = this.getTargetPlayer(ctx);
        if (player == null) {
            return;
        }
        String reason = ctx.queryParam("r");
        player.ban(reason != null ? Utils.base64ToString(reason) : null);
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler pardonPlayer = ctx -> {
        OPanelPlayer player = this.getTargetPlayer(ctx);
        if (player == null) {
            return;
        }
        player.pardon();
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler setGamemode = ctx -> {
        OPanelPlayer player = this.getTargetPlayer(ctx);
        if (player == null) {
            return;
        }
        String gamemode = ctx.queryParam("gm");
        if (gamemode == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Gamemode is required.");
            return;
        }
        player.setGameMode(OPanelGameMode.fromString(gamemode));
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler deletePlayerData = ctx -> {
        String uuid = ctx.queryParam("uuid");
        if (uuid == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Uuid is required.");
            return;
        }
        if (this.server.getPlayer(uuid) == null) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Player not found.");
            return;
        }
        this.server.removePlayerData(uuid);
        this.sendResponse(ctx, HttpStatus.OK);
    };

    public PlayersController(OPanel plugin) {
        super(plugin);
    }

    private OPanelPlayer getTargetPlayer(Context ctx) {
        String uuid = ctx.queryParam("uuid");
        if (uuid == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Uuid is required.");
            return null;
        }
        OPanelPlayer player = this.server.getPlayer(uuid);
        if (player == null) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Player not found.");
            return null;
        }
        return player;
    }
}

