/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.ServerType;
import net.opanel.common.features.BukkitConfigFeature;
import net.opanel.common.features.CodeOfConductFeature;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.utils.Utils;

public class ControlController
extends BaseController {
    public Handler getServerProperties = ctx -> {
        try {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("properties", Utils.stringToBase64(OPanelServer.getPropertiesContent()));
            this.sendResponse(ctx, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler setServerProperties = ctx -> {
        try {
            String properties = ctx.body().replaceAll("\"", "");
            if (properties.isEmpty()) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "server.properties content is missing.");
                return;
            }
            OPanelServer.writePropertiesContent(Utils.base64ToString(properties));
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler getCodeOfConducts = ctx -> {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (!(this.server instanceof CodeOfConductFeature)) {
            this.sendResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, "Minecraft versions lower than 1.21.9 don't support server code-of-conduct.");
            return;
        }
        try {
            HashMap<String, String> codeOfConducts = ((CodeOfConductFeature)((Object)this.server)).getCodeOfConducts();
            codeOfConducts.replaceAll((lang, content) -> Utils.stringToBase64(content));
            obj.put("codeOfConducts", codeOfConducts);
            this.sendResponse(ctx, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler changeCodeOfConduct = ctx -> {
        if (!(this.server instanceof CodeOfConductFeature)) {
            this.sendResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, "Minecraft versions lower than 1.21.9 don't support server code-of-conduct.");
            return;
        }
        try {
            String lang = ctx.queryParam("lang");
            if (lang == null) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Language is missing.");
                return;
            }
            String content = ctx.body().replaceAll("\"", "");
            ((CodeOfConductFeature)((Object)this.server)).updateOrCreateCodeOfConduct(lang, !content.isEmpty() ? Utils.base64ToString(content) : "");
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler removeCodeOfConduct = ctx -> {
        if (!(this.server instanceof CodeOfConductFeature)) {
            this.sendResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, "Minecraft versions lower than 1.21.9 don't support server code-of-conduct.");
            return;
        }
        try {
            String lang = ctx.queryParam("lang");
            if (lang == null) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Language is missing.");
                return;
            }
            ((CodeOfConductFeature)((Object)this.server)).removeCodeOfConduct(lang);
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler stopServer = ctx -> {
        this.server.stop();
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler reloadServer = ctx -> {
        this.server.reload();
        this.sendResponse(ctx, HttpStatus.OK);
    };
    public Handler switchSave = ctx -> {
        String saveName = ctx.queryParam("save");
        if (saveName == null) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Save name is missing.");
            return;
        }
        OPanelSave save = this.server.getSave(saveName);
        if (save == null) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the save.");
            return;
        }
        try {
            save.setToCurrent();
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler getBukkitServerConfig = ctx -> {
        if (!(this.server instanceof BukkitConfigFeature)) {
            this.sendResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, "This server is not a bukkit server.");
            return;
        }
        ServerType serverType = this.server.getServerType();
        try {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("bukkit", Utils.stringToBase64(((BukkitConfigFeature)((Object)this.server)).getBukkitServerConfigContent("bukkit")));
            if (serverType == ServerType.SPIGOT || serverType == ServerType.PAPER || serverType == ServerType.FOLIA) {
                obj.put("spigot", Utils.stringToBase64(((BukkitConfigFeature)((Object)this.server)).getBukkitServerConfigContent("spigot")));
            }
            if (serverType == ServerType.PAPER || serverType == ServerType.FOLIA) {
                obj.put("paper", Utils.stringToBase64(((BukkitConfigFeature)((Object)this.server)).getBukkitServerConfigContent("paper")));
            }
            this.sendResponse(ctx, obj);
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Unknown target.");
        }
        catch (NoSuchFileException e) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the target bukkit server config.");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler setBukkitServerConfig = ctx -> {
        if (!(this.server instanceof BukkitConfigFeature)) {
            this.sendResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, "This server is not a bukkit server.");
            return;
        }
        try {
            String target = ctx.queryParam("target");
            if (target == null) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Target is missing.");
                return;
            }
            String content = ctx.body().replaceAll("\"", "");
            if (content.isEmpty()) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Config content is missing.");
                return;
            }
            ((BukkitConfigFeature)((Object)this.server)).writeBukkitServerConfigContent(target, Utils.base64ToString(content));
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Unknown target.");
        }
        catch (NoSuchFileException e) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the target bukkit server config.");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler getPaperWorldConfig = ctx -> {
        if (!(this.server instanceof BukkitConfigFeature)) {
            this.sendResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, "This server is not a bukkit server.");
            return;
        }
        try {
            String worldName = ctx.queryParam("world");
            HashMap<String, Object> obj = new HashMap<String, Object>();
            if (worldName == null) {
                obj.put("config", ((BukkitConfigFeature)((Object)this.server)).getPaperWorldDefaultsConfigContent());
            } else {
                obj.put("config", ((BukkitConfigFeature)((Object)this.server)).getPaperWorldConfigContent(worldName));
            }
            this.sendResponse(ctx, obj);
        }
        catch (NoSuchFileException e) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the world config.");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler setPaperWorldConfig = ctx -> {
        if (!(this.server instanceof BukkitConfigFeature)) {
            this.sendResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, "This server is not a bukkit server.");
            return;
        }
        try {
            String worldName = ctx.queryParam("world");
            String content = ctx.body().replaceAll("\"", "");
            if (content.isEmpty()) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Config content is missing.");
            }
            if (worldName == null) {
                ((BukkitConfigFeature)((Object)this.server)).writePaperWorldDefaultsConfigContent(Utils.base64ToString(content));
            } else {
                ((BukkitConfigFeature)((Object)this.server)).writePaperWorldConfigContent(worldName, Utils.base64ToString(content));
            }
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (NoSuchFileException e) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the world config.");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };

    public ControlController(OPanel plugin) {
        super(plugin);
    }
}

