/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecretKeyBuilder;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import net.opanel.utils.Utils;

public class JwtManager {
    private static final SecretKey signKey = (SecretKey)((SecretKeyBuilder)Jwts.SIG.HS256.key()).build();
    private static final Header accessKeyHeader = (Header)((Jwts.HeaderBuilder)Jwts.header().keyId("accessKey")).build();
    private static final String issuer = "opanel";

    public static String generateToken(String hashedAccessKey, String salt) {
        String access = Utils.md5(salt + hashedAccessKey);
        Date current = new Date();
        return ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().add(accessKeyHeader)).and()).issuer(issuer).expiration(new Date(current.getTime() + TimeUnit.DAYS.toMillis(1L))).issuedAt(current).claim("access", access).signWith(signKey).compact();
    }

    public static boolean verifyToken(String token, String hashedAccessKey, String salt) {
        String access = Utils.md5(salt + hashedAccessKey);
        Date current = new Date();
        try {
            Jws<Claims> jws = Jwts.parser().verifyWith(signKey).build().parseSignedClaims(token);
            if (!((JwsHeader)jws.getHeader()).getKeyId().equals("accessKey")) {
                return false;
            }
            Claims payload = (Claims)jws.getPayload();
            if (!payload.getIssuer().equals(issuer)) {
                return false;
            }
            if (current.after(payload.getExpiration())) {
                return false;
            }
            if (!payload.get("access").equals(access)) {
                return false;
            }
        }
        catch (JwtException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

