/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.time;

public class TPS {
    public static final int TICK_LIST_SIZE = 100;
    private static final long PAUSE_THRESHOLD_NS = 2000000000L;
    private static final long[] tickTimes = new long[100];
    private static volatile int tickIndex = 0;

    public static synchronized void onTick() {
        TPS.tickTimes[TPS.tickIndex] = System.nanoTime();
        tickIndex = (tickIndex + 1) % 100;
    }

    public static synchronized double getRecentMSPT() {
        long totalTime = 0L;
        int validTicks = 0;
        for (int i = 0; i < 99; ++i) {
            long duration;
            long start2 = tickTimes[i];
            long end = tickTimes[(i + 1) % 100];
            if (start2 <= 0L || end <= 0L || end <= start2 || (duration = end - start2) >= 2000000000L) continue;
            totalTime += duration;
            ++validTicks;
        }
        return validTicks > 0 ? (double)totalTime / (double)validTicks / 1000000.0 : 50.0;
    }

    public static double getRecentTPS() {
        double mspt = TPS.getRecentMSPT();
        if (mspt <= 0.0) {
            return 20.0;
        }
        double tps = 1000.0 / mspt;
        return Math.min(20.0, Math.max(0.0, tps));
    }

    public static synchronized boolean isPaused() {
        long current = System.nanoTime();
        int lastIndex = (tickIndex - 1 + 100) % 100;
        long lastTickTime = tickTimes[lastIndex];
        return lastTickTime > 0L && current - lastTickTime >= 2000000000L;
    }
}

