/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.endpoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.opanel.OPanel;
import net.opanel.common.OPanelPlayer;
import net.opanel.deps.javalin.Javalin;
import net.opanel.deps.javalin.websocket.WsConfig;
import net.opanel.deps.javalin.websocket.WsMessageContext;
import net.opanel.endpoint.BaseEndpoint;
import net.opanel.endpoint.Packet;
import net.opanel.event.EventManager;
import net.opanel.event.EventType;
import net.opanel.utils.Utils;

public class PlayersEndpoint
extends BaseEndpoint {
    public PlayersEndpoint(Javalin app, WsConfig ws, OPanel plugin) {
        super(app, ws, plugin);
        EventManager.get().on(EventType.PLAYER_JOIN, event -> {
            try {
                List<String> whitelistedNames = this.server.getWhitelist().getNames();
                this.broadcast(new PlayersPacket<HashMap<String, Object>>("join", this.serializePlayer(event.getPlayer(), whitelistedNames)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        EventManager.get().on(EventType.PLAYER_LEAVE, event -> {
            try {
                List<String> whitelistedNames = this.server.getWhitelist().getNames();
                HashMap<String, Object> playerInfo = this.serializePlayer(event.getPlayer(), whitelistedNames);
                playerInfo.put("isOnline", false);
                this.broadcast(new PlayersPacket<HashMap<String, Object>>("leave", playerInfo));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        EventManager.get().on(EventType.PLAYER_GAMEMODE_CHANGE, event -> {
            try {
                List<String> whitelistedNames = this.server.getWhitelist().getNames();
                HashMap<String, Object> playerInfo = this.serializePlayer(event.getPlayer(), whitelistedNames);
                playerInfo.put("gamemode", event.getGameMode().getName());
                this.broadcast(new PlayersPacket<HashMap<String, Object>>("gamemode-change", playerInfo));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void onConnect(WsMessageContext ctx) {
        this.sendPlayerList(ctx);
        this.subscribe(ctx.session, "fetch", this::sendPlayerList);
    }

    private void sendPlayerList(WsMessageContext ctx) {
        try {
            List<String> whitelistedNames = this.server.getWhitelist().getNames();
            List players = this.server.getPlayers().stream().map(player -> this.serializePlayer((OPanelPlayer)player, whitelistedNames)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            ctx.send(new PlayersPacket<List>("init", players));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, Object> serializePlayer(OPanelPlayer player, List<String> whitelistedNames) {
        HashMap<String, Object> playerInfo = new HashMap<String, Object>();
        playerInfo.put("name", player.getName());
        playerInfo.put("uuid", player.getUUID());
        playerInfo.put("isOnline", player.isOnline());
        playerInfo.put("isOp", player.isOp());
        playerInfo.put("isBanned", player.isBanned());
        playerInfo.put("gamemode", player.getGameMode().getName());
        String banReason = player.getBanReason();
        if (banReason != null) {
            playerInfo.put("banReason", Utils.stringToBase64(banReason));
        }
        if (this.server.isWhitelistEnabled()) {
            playerInfo.put("isWhitelisted", whitelistedNames.contains(player.getName()));
        }
        if (player.isOnline()) {
            playerInfo.put("ping", player.getPing());
        }
        return playerInfo;
    }

    private static class PlayersPacket<D>
    extends Packet<D> {
        public static final String INIT = "init";
        public static final String FETCH = "fetch";
        public static final String JOIN = "join";
        public static final String LEAVE = "leave";
        public static final String GAMEMODE_CHANGE = "gamemode-change";

        public PlayersPacket(String type, D data) {
            super(type, data);
        }
    }
}

