/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.common;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelWhitelist;
import net.opanel.common.ServerType;
import net.opanel.utils.Utils;

public interface OPanelServer {
    public static final Path serverPropertiesPath = Paths.get("", new String[0]).resolve("server.properties");
    public static final Path serverIconPath = Paths.get("", new String[0]).resolve("server-icon.png");

    public ServerType getServerType();

    default public byte[] getFavicon() {
        if (!Files.exists(serverIconPath, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readAllBytes(serverIconPath);
        }
        catch (IOException e) {
            return null;
        }
    }

    default public void setFavicon(byte[] iconBytes) throws IOException {
        Files.write(serverIconPath, iconBytes, new OpenOption[0]);
    }

    public String getMotd();

    public void setMotd(String var1) throws IOException;

    public String getVersion();

    public int getPort();

    public List<OPanelSave> getSaves();

    public OPanelSave getSave(String var1);

    public void saveAll();

    public List<OPanelPlayer> getOnlinePlayers();

    public List<OPanelPlayer> getPlayers();

    public int getMaxPlayerCount();

    public OPanelPlayer getPlayer(String var1);

    public void removePlayerData(String var1) throws IOException;

    public List<String> getBannedIps();

    public void banIp(String var1) throws UnknownHostException;

    public void pardonIp(String var1) throws UnknownHostException;

    public boolean isWhitelistEnabled();

    public void setWhitelistEnabled(boolean var1);

    public OPanelWhitelist getWhitelist();

    public void sendServerCommand(String var1);

    public List<String> getCommands();

    public List<String> getCommandTabList(int var1, String var2);

    public HashMap<String, Object> getGamerules();

    public void setGamerules(HashMap<String, Object> var1);

    public void reload();

    public void stop();

    public long getIngameTime();

    public static String getPropertiesContent() throws IOException {
        if (!Files.exists(serverPropertiesPath, new LinkOption[0])) {
            throw new IOException("Cannot find server.properties");
        }
        return Utils.readTextFile(serverPropertiesPath);
    }

    public static void writePropertiesContent(String newContent) throws IOException {
        if (!Files.exists(serverPropertiesPath, new LinkOption[0])) {
            throw new IOException("Cannot find server.properties");
        }
        Utils.writeTextFile(serverPropertiesPath, newContent);
    }
}

