/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_21_2;

import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;
import net.opanel.OPanel;
import net.opanel.config.OPanelConfiguration;
import net.opanel.fabric_1_21_2.FabricListener;
import net.opanel.fabric_1_21_2.FabricServer;
import net.opanel.fabric_1_21_2.LoggerImpl;
import net.opanel.fabric_1_21_2.command.OPanelCommand;
import net.opanel.fabric_1_21_2.terminal.LogListenerManagerImpl;
import net.opanel.fabric_helper.config.ConfigManagerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import space.nocp.configx.api.ConfigManager;
import space.nocp.configx.api.Configuration;

public class Main
implements DedicatedServerModInitializer {
    public static final String MODID = "opanel";
    public static final Logger LOGGER = LoggerFactory.getLogger("opanel");
    public OPanel instance;
    private LogListenerManagerImpl logListenerAppender;

    public void onInitializeServer() {
        Configuration configSrc = ConfigManager.get().register(MODID, (Object)OPanelConfiguration.defaultConfig, OPanelConfiguration.class);
        this.instance = new OPanel(new ConfigManagerImpl((Configuration<OPanelConfiguration>)configSrc), new LoggerImpl(LOGGER));
        this.initLogListenerAppender();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStop);
        ServerTickEvents.START_SERVER_TICK.register(this::onServerTick);
        new FabricListener();
        CommandRegistrationCallback.EVENT.register((Object)new OPanelCommand(this.instance));
    }

    private void initLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        this.logListenerAppender = LogListenerManagerImpl.createAppender("LogListenerAppender", true);
        this.logListenerAppender.start();
        logger.addAppender((Appender)this.logListenerAppender);
        this.instance.setLogListenerManager(this.logListenerAppender);
    }

    private void disposeLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.removeAppender((Appender)this.logListenerAppender);
        this.logListenerAppender.clearListeners();
    }

    private void onServerStart(MinecraftServer server) {
        this.instance.setServer(new FabricServer(server));
        try {
            this.instance.getWebServer().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onServerStop(MinecraftServer server) {
        try {
            if (this.logListenerAppender != null) {
                this.disposeLogListenerAppender();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to dispose log listener appender: " + e.getMessage());
        }
        try {
            if (this.instance != null) {
                this.instance.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop OPanel instance: " + e.getMessage());
        }
    }

    private void onServerTick(MinecraftServer server) {
        this.instance.onTick();
    }
}

