/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.FamilyJwkFactory;
import io.jsonwebtoken.impl.security.JcaTemplate;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.KeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.util.Set;

abstract class AbstractFamilyJwkFactory<K extends Key, J extends Jwk<K>>
implements FamilyJwkFactory<K, J> {
    private final String ktyValue;
    private final Class<K> keyType;
    private final Set<Parameter<?>> params;

    protected static <T> void put(JwkContext<?> ctx, Parameter<T> param, T value) {
        ctx.put(param.getId(), param.applyTo(value));
    }

    AbstractFamilyJwkFactory(String ktyValue, Class<K> keyType, Set<Parameter<?>> params) {
        this.ktyValue = Assert.hasText(ktyValue, "keyType argument cannot be null or empty.");
        this.keyType = Assert.notNull(keyType, "keyType class cannot be null.");
        this.params = Assert.notEmpty(params, "Parameters collection cannot be null or empty.");
    }

    @Override
    public String getId() {
        return this.ktyValue;
    }

    @Override
    public boolean supports(Key key) {
        return this.keyType.isInstance(key);
    }

    @Override
    public JwkContext<K> newContext(JwkContext<?> src, K key) {
        Assert.notNull(src, "Source JwkContext cannot be null.");
        return key != null ? new DefaultJwkContext<K>(this.params, src, key) : new DefaultJwkContext(this.params, src, false);
    }

    @Override
    public boolean supports(JwkContext<?> ctx) {
        return this.supports((Key)ctx.getKey()) || this.supportsKeyValues(ctx);
    }

    protected boolean supportsKeyValues(JwkContext<?> ctx) {
        return this.ktyValue.equals(ctx.getType());
    }

    protected K generateKey(JwkContext<K> ctx, CheckedFunction<KeyFactory, K> fn) {
        return this.generateKey(ctx, this.keyType, fn);
    }

    protected String getKeyFactoryJcaName(JwkContext<?> ctx) {
        String jcaName = KeysBridge.findAlgorithm(ctx.getKey());
        return Strings.hasText(jcaName) ? jcaName : this.getId();
    }

    protected <T extends Key> T generateKey(final JwkContext<?> ctx, final Class<T> type, final CheckedFunction<KeyFactory, T> fn) {
        String jcaName = this.getKeyFactoryJcaName(ctx);
        JcaTemplate template = new JcaTemplate(jcaName, ctx.getProvider(), ctx.getRandom());
        return (T)((Key)template.withKeyFactory(new CheckedFunction<KeyFactory, T>(){

            @Override
            public T apply(KeyFactory instance) {
                try {
                    return (Key)fn.apply(instance);
                }
                catch (KeyException keyException) {
                    throw keyException;
                }
                catch (Exception e) {
                    String msg = "Unable to create " + type.getSimpleName() + " from JWK " + ctx + ": " + e.getMessage();
                    throw new InvalidKeyException(msg, e);
                }
            }
        }));
    }

    @Override
    public final J createJwk(JwkContext<K> ctx) {
        Assert.notNull(ctx, "JwkContext argument cannot be null.");
        if (!this.supports(ctx)) {
            String msg = "Unsupported JwkContext.";
            throw new IllegalArgumentException(msg);
        }
        K key = ctx.getKey();
        if (key != null) {
            ctx.setType(this.ktyValue);
            return this.createJwkFromKey(ctx);
        }
        return this.createJwkFromValues(ctx);
    }

    protected abstract J createJwkFromKey(JwkContext<K> var1);

    protected abstract J createJwkFromValues(JwkContext<K> var1);
}

