/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.bukkit_helper;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.opanel.bukkit_helper.TaskRunner;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.deps.nbtapi.NBT;
import net.opanel.deps.nbtapi.iface.ReadWriteNBT;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseBukkitOfflinePlayer
implements OPanelPlayer {
    protected final JavaPlugin plugin;
    protected final TaskRunner runner;
    protected final OfflinePlayer player;
    protected final Server server;
    protected final Path playerDataPath;

    public BaseBukkitOfflinePlayer(JavaPlugin plugin, Server server, OfflinePlayer player) {
        this.plugin = plugin;
        this.runner = (TaskRunner)plugin;
        this.server = server;
        this.player = player;
        if (player.isOnline()) {
            throw new IllegalStateException("The player is offline.");
        }
        String uuid = player.getUniqueId().toString();
        this.playerDataPath = ((World)server.getWorlds().get(0)).getWorldFolder().toPath().resolve("playerdata/" + uuid + ".dat");
        if (!Files.exists(this.playerDataPath, new LinkOption[0])) {
            throw new NullPointerException("Player data file for UUID " + uuid + " unavailable.");
        }
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public String getUUID() {
        return this.player.getUniqueId().toString();
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public boolean isOp() {
        return this.player.isOp();
    }

    @Override
    public boolean isBanned() {
        return this.player.isBanned();
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            ReadWriteNBT nbt = NBT.readFile(this.playerDataPath.toFile());
            int gamemode = nbt.getInteger("playerGameType");
            return OPanelGameMode.fromId(gamemode);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            ReadWriteNBT nbt = NBT.readFile(this.playerDataPath.toFile());
            nbt.setInteger("playerGameType", gamemode.getId());
            NBT.writeFile(this.playerDataPath.toFile(), nbt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.runner.runTask(() -> this.player.setOp(true));
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.runner.runTask(() -> this.player.setOp(false));
    }

    @Override
    public void kick(String reason) {
        throw new IllegalStateException("The player is offline.");
    }

    @Override
    public int getPing() {
        throw new IllegalStateException("The player is offline.");
    }
}

