/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_8;

import java.util.Date;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.world.level.GameType;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.forge_helper.BaseForgePlayer;

public class ForgePlayer
extends BaseForgePlayer
implements OPanelPlayer {
    public ForgePlayer(ServerPlayer player) {
        super(player, player.getServer());
    }

    @Override
    public boolean isOp() {
        if (this.player == null) {
            return false;
        }
        return this.playerManager.isOp(this.profile);
    }

    @Override
    public OPanelGameMode getGameMode() {
        if (this.player == null) {
            return null;
        }
        GameType gamemode = this.player.gameMode();
        return OPanelGameMode.fromId(gamemode.getId());
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        if (this.player == null) {
            return;
        }
        this.player.setGameMode(GameType.byId((int)gamemode.getId()));
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.op(this.profile);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.deop(this.profile);
    }

    @Override
    public void kick(String reason) {
        this.player.connection.disconnect(Component.nullToEmpty((String)reason));
    }

    @Override
    public void ban(String reason) {
        UserBanList bannedList = this.playerManager.getBans();
        UserBanListEntry entry = new UserBanListEntry(this.profile, new Date(), null, null, reason);
        bannedList.add((StoredUserEntry)entry);
        this.kick(reason);
    }

    @Override
    public int getPing() {
        return this.player.connection.latency();
    }
}

