/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_9;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.opanel.common.OPanelDifficulty;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.forge_helper.BaseForgeSave;
import net.opanel.forge_helper.ForgeUtils;

public class ForgeSave
extends BaseForgeSave
implements OPanelSave {
    private CompoundTag nbt;

    public ForgeSave(MinecraftServer server, Path path) {
        super(server, path);
        try {
            Optional optionalNbt = NbtIo.readCompressed((Path)this.savePath.resolve("level.dat"), (NbtAccounter)NbtAccounter.unlimitedHeap()).get("Data").asCompound();
            if (optionalNbt.isEmpty()) {
                throw new IOException("Cannot find a valid level.dat");
            }
            this.nbt = (CompoundTag)optionalNbt.get();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveNbt() throws IOException {
        CompoundTag dataNbt = new CompoundTag();
        dataNbt.put("Data", (Tag)this.nbt);
        NbtIo.writeCompressed((CompoundTag)dataNbt, (Path)this.savePath.resolve("level.dat"));
    }

    @Override
    public String getDisplayName() {
        return this.nbt.getStringOr("LevelName", "world").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.putString("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        int gamemode = this.nbt.getIntOr("GameType", 0);
        return OPanelGameMode.fromId(gamemode);
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        this.nbt.putInt("GameType", gamemode.getId());
        this.saveNbt();
    }

    @Override
    public OPanelDifficulty getDifficulty() throws IOException {
        if (this.isCurrent()) {
            return OPanelDifficulty.fromId(this.getCurrentWorld().getDifficulty().getId());
        }
        byte difficulty = this.nbt.getByteOr("Difficulty", (byte)0);
        return OPanelDifficulty.fromId(difficulty);
    }

    @Override
    public void setDifficulty(OPanelDifficulty difficulty) throws IOException {
        if (this.isCurrent()) {
            this.server.setDifficulty(Difficulty.byName((String)difficulty.getName()), true);
        }
        this.nbt.putByte("Difficulty", (byte)difficulty.getId());
        this.saveNbt();
    }

    @Override
    public boolean isDifficultyLocked() throws IOException {
        if (this.isCurrent()) {
            return this.getCurrentWorld().getLevelData().isDifficultyLocked();
        }
        return this.nbt.getByteOr("DifficultyLocked", (byte)0) == 1;
    }

    @Override
    public void setDifficultyLocked(boolean locked) throws IOException {
        if (this.isCurrent()) {
            this.server.setDifficultyLocked(locked);
        }
        this.nbt.putByte("DifficultyLocked", (byte)(locked ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public boolean isHardcore() throws IOException {
        if (this.isCurrent()) {
            return this.server.isHardcore();
        }
        return this.nbt.getByteOr("hardcore", (byte)0) == 1;
    }

    @Override
    public void setHardcoreEnabled(boolean enabled) throws IOException {
        if (this.isCurrent()) {
            PrimaryLevelData worldData = (PrimaryLevelData)this.getCurrentWorld().getLevelData();
            LevelSettings currentSettings = worldData.getLevelSettings();
            LevelSettings newSettings = new LevelSettings(currentSettings.levelName(), currentSettings.gameType(), enabled, currentSettings.difficulty(), currentSettings.allowCommands(), currentSettings.gameRules(), currentSettings.getDataConfiguration());
            try {
                Field settingsField = PrimaryLevelData.class.getDeclaredField("settings");
                settingsField.setAccessible(true);
                settingsField.set(worldData, newSettings);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("hardcore=.+", "hardcore=" + enabled));
            ForgeUtils.forceUpdateProperties((DedicatedServer)this.server, false);
        }
        this.nbt.putByte("hardcore", (byte)(enabled ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public HashMap<String, Boolean> getDatapacks() {
        HashMap<String, Boolean> datapacks = new HashMap<String, Boolean>();
        Optional optionalDatapacksNbt = this.nbt.getCompound("DataPacks");
        if (optionalDatapacksNbt.isEmpty()) {
            return datapacks;
        }
        CompoundTag datapacksNbt = (CompoundTag)optionalDatapacksNbt.get();
        Optional optionalEnabledListNbt = datapacksNbt.getList("Enabled");
        Optional optionalDisabledListNbt = datapacksNbt.getList("Disabled");
        optionalEnabledListNbt.ifPresent(tags -> tags.forEach(tag -> datapacks.put((String)tag.asString().get(), true)));
        optionalDisabledListNbt.ifPresent(tags -> tags.forEach(tag -> datapacks.put((String)tag.asString().get(), false)));
        return datapacks;
    }

    @Override
    public void toggleDatapack(String id, boolean enabled) throws IOException {
        Optional optionalDatapacksNbt;
        Boolean currentEnabled = this.getDatapacks().get(id);
        if (currentEnabled == null || currentEnabled == enabled) {
            return;
        }
        if (id.equals("vanilla")) {
            return;
        }
        if (this.isCurrent()) {
            this.server.getCommands().performPrefixedCommand(this.server.createCommandSourceStack(), "datapack " + (enabled ? "enable" : "disable") + " \"" + id + "\"");
        }
        if ((optionalDatapacksNbt = this.nbt.getCompound("DataPacks")).isEmpty()) {
            return;
        }
        CompoundTag datapacksNbt = (CompoundTag)optionalDatapacksNbt.get();
        Optional optionalEnabledListNbt = datapacksNbt.getList("Enabled");
        Optional optionalDisabledListNbt = datapacksNbt.getList("Disabled");
        if (enabled) {
            optionalDisabledListNbt.ifPresent(tags -> tags.remove((Object)StringTag.valueOf((String)id)));
            optionalEnabledListNbt.ifPresent(tags -> tags.add((Object)StringTag.valueOf((String)id)));
        } else {
            optionalEnabledListNbt.ifPresent(tags -> tags.remove((Object)StringTag.valueOf((String)id)));
            optionalDisabledListNbt.ifPresent(tags -> tags.add((Object)StringTag.valueOf((String)id)));
        }
        this.saveNbt();
    }
}

