/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_8;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.forge_helper.BaseForgeOfflinePlayer;

public class ForgeOfflinePlayer
extends BaseForgeOfflinePlayer
implements OPanelPlayer {
    private final GameProfile profile;

    public ForgeOfflinePlayer(MinecraftServer server, UUID uuid) {
        super(server, uuid);
        GameProfileCache profileCache = server.getProfileCache();
        if (profileCache == null) {
            throw new NullPointerException("Cannot get player profile cache.");
        }
        Optional profileOpt = profileCache.get(uuid);
        if (profileOpt.isEmpty()) {
            throw new NullPointerException("Cannot get the game profile of the provided player.");
        }
        this.profile = (GameProfile)profileOpt.get();
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public boolean isOp() {
        return this.playerManager.isOp(this.profile);
    }

    @Override
    public boolean isBanned() {
        return this.playerManager.getBans().isBanned(this.profile);
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            CompoundTag nbt = NbtIo.readCompressed((Path)this.playerDataPath, (NbtAccounter)NbtAccounter.unlimitedHeap());
            int gamemodeId = nbt.getIntOr("playerGameType", 0);
            return OPanelGameMode.fromId(gamemodeId);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            CompoundTag nbt = NbtIo.readCompressed((Path)this.playerDataPath, (NbtAccounter)NbtAccounter.unlimitedHeap());
            nbt.putInt("playerGameType", gamemode.getId());
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)this.playerDataPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.op(this.profile);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.deop(this.profile);
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        UserBanList bannedList = this.playerManager.getBans();
        UserBanListEntry entry = new UserBanListEntry(this.profile, new Date(), null, null, reason);
        bannedList.add((StoredUserEntry)entry);
    }

    @Override
    public String getBanReason() {
        if (!this.isBanned()) {
            return null;
        }
        UserBanListEntry banEntry = (UserBanListEntry)this.playerManager.getBans().get((Object)this.profile);
        if (banEntry == null) {
            return null;
        }
        return banEntry.getReason();
    }

    @Override
    public void pardon() {
        if (!this.isBanned()) {
            return;
        }
        this.playerManager.getBans().remove((Object)this.profile);
    }
}

