/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_1;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.opanel.common.OPanelDifficulty;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.forge_helper.BaseForgeSave;
import net.opanel.forge_helper.ForgeUtils;

public class ForgeSave
extends BaseForgeSave
implements OPanelSave {
    private CompoundTag nbt;

    public ForgeSave(MinecraftServer server, Path path) {
        super(server, path);
        try {
            this.nbt = NbtIo.m_128937_((File)this.savePath.resolve("level.dat").toFile()).m_128469_("Data");
            if (this.nbt.m_128456_()) {
                throw new IOException("Cannot find a valid level.dat");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveNbt() throws IOException {
        CompoundTag dataNbt = new CompoundTag();
        dataNbt.m_128365_("Data", (Tag)this.nbt);
        NbtIo.m_128944_((CompoundTag)dataNbt, (File)this.savePath.resolve("level.dat").toFile());
    }

    @Override
    public String getDisplayName() {
        return this.nbt.m_128461_("LevelName").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.m_128359_("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        int gamemode = this.nbt.m_128451_("GameType");
        return OPanelGameMode.fromId(gamemode);
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        this.nbt.m_128405_("GameType", gamemode.getId());
        this.saveNbt();
    }

    @Override
    public OPanelDifficulty getDifficulty() throws IOException {
        if (this.isCurrent()) {
            return OPanelDifficulty.fromId(this.getCurrentWorld().m_46791_().m_19028_());
        }
        byte difficulty = this.nbt.m_128445_("Difficulty");
        return OPanelDifficulty.fromId(difficulty);
    }

    @Override
    public void setDifficulty(OPanelDifficulty difficulty) throws IOException {
        if (this.isCurrent()) {
            this.server.m_129827_(Difficulty.m_19031_((String)difficulty.getName()), true);
        }
        this.nbt.m_128344_("Difficulty", (byte)difficulty.getId());
        this.saveNbt();
    }

    @Override
    public boolean isDifficultyLocked() throws IOException {
        if (this.isCurrent()) {
            return this.getCurrentWorld().m_6106_().m_5474_();
        }
        return this.nbt.m_128445_("DifficultyLocked") == 1;
    }

    @Override
    public void setDifficultyLocked(boolean locked) throws IOException {
        if (this.isCurrent()) {
            this.server.m_129958_(locked);
        }
        this.nbt.m_128344_("DifficultyLocked", (byte)(locked ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public boolean isHardcore() throws IOException {
        if (this.isCurrent()) {
            return this.server.m_7035_();
        }
        return this.nbt.m_128445_("hardcore") == 1;
    }

    @Override
    public void setHardcoreEnabled(boolean enabled) throws IOException {
        if (this.isCurrent()) {
            PrimaryLevelData worldData = (PrimaryLevelData)this.getCurrentWorld().m_6106_();
            LevelSettings currentSettings = worldData.m_5926_();
            LevelSettings newSettings = new LevelSettings(currentSettings.m_46917_(), currentSettings.m_46929_(), enabled, currentSettings.m_46931_(), currentSettings.m_46932_(), currentSettings.m_46933_(), currentSettings.m_246291_());
            try {
                Field settingsField = PrimaryLevelData.class.getDeclaredField("f_78443_");
                settingsField.setAccessible(true);
                settingsField.set(worldData, newSettings);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("hardcore=.+", "hardcore=" + enabled));
            ForgeUtils.forceUpdateProperties((DedicatedServer)this.server, true);
        }
        this.nbt.m_128344_("hardcore", (byte)(enabled ? 1 : 0));
        this.saveNbt();
    }

    @Override
    public HashMap<String, Boolean> getDatapacks() {
        HashMap<String, Boolean> datapacks = new HashMap<String, Boolean>();
        CompoundTag datapacksNbt = this.nbt.m_128469_("DataPacks");
        datapacksNbt.m_128437_("Enabled", 8).forEach(tag -> datapacks.put(tag.m_7916_(), true));
        datapacksNbt.m_128437_("Disabled", 8).forEach(tag -> datapacks.put(tag.m_7916_(), false));
        return datapacks;
    }

    @Override
    public void toggleDatapack(String id, boolean enabled) throws IOException {
        Boolean currentEnabled = this.getDatapacks().get(id);
        if (currentEnabled == null || currentEnabled == enabled) {
            return;
        }
        if (id.equals("vanilla")) {
            return;
        }
        if (this.isCurrent()) {
            this.server.m_129892_().m_230957_(this.server.m_129893_(), "datapack " + (enabled ? "enable" : "disable") + " \"" + id + "\"");
        }
        CompoundTag datapacksNbt = this.nbt.m_128469_("DataPacks");
        if (enabled) {
            datapacksNbt.m_128437_("Disabled", 8).remove((Object)StringTag.m_129297_((String)id));
            datapacksNbt.m_128437_("Enabled", 8).add((Object)StringTag.m_129297_((String)id));
        } else {
            datapacksNbt.m_128437_("Enabled", 8).remove((Object)StringTag.m_129297_((String)id));
            datapacksNbt.m_128437_("Disabled", 8).add((Object)StringTag.m_129297_((String)id));
        }
        this.saveNbt();
    }
}

