/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.endpoint;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.opanel.OPanel;
import net.opanel.deps.javalin.Javalin;
import net.opanel.deps.javalin.websocket.WsConfig;
import net.opanel.deps.javalin.websocket.WsMessageContext;
import net.opanel.endpoint.BaseEndpoint;
import net.opanel.endpoint.Packet;
import net.opanel.terminal.ConsoleLog;
import net.opanel.terminal.LogListenerManager;
import org.eclipse.jetty.websocket.api.Session;

public class TerminalEndpoint
extends BaseEndpoint {
    private final LogListenerManager logListenerManager;
    private static final AtomicBoolean hasLogListenerRegistered = new AtomicBoolean(false);

    public TerminalEndpoint(Javalin app, WsConfig ws, OPanel plugin) {
        super(app, ws, plugin);
        this.logListenerManager = plugin.getLogListenerManager();
        if (hasLogListenerRegistered.compareAndSet(false, true)) {
            this.logListenerManager.addListener(log -> this.broadcast(new TerminalPacket<ConsoleLog>("log", (ConsoleLog)log)));
        }
    }

    @Override
    public void onConnect(WsMessageContext ctx) {
        Session session = ctx.session;
        ctx.send(new TerminalPacket<List<ConsoleLog>>("init", this.logListenerManager.getRecentLogs()));
        this.subscribe(session, "command", String.class, (msgCtx, command) -> {
            if (command.startsWith("/")) {
                command = command.replace("/", "");
            }
            this.plugin.getServer().sendServerCommand((String)command);
        });
        this.subscribe(session, "autocomplete", AutocompletePacketData.class, (msgCtx, data) -> {
            if (data.argIndex == 1) {
                ctx.send(new TerminalPacket<List<String>>("autocomplete", this.plugin.getServer().getCommands()));
                return;
            }
            ctx.send(new TerminalPacket<List<String>>("autocomplete", this.plugin.getServer().getCommandTabList(data.argIndex, data.command)));
        });
    }

    private static class TerminalPacket<D>
    extends Packet<D> {
        public static final String INIT = "init";
        public static final String LOG = "log";
        public static final String AUTOCOMPLETE = "autocomplete";
        public static final String COMMAND = "command";

        public TerminalPacket(String type, D data) {
            super(type, data);
        }
    }

    private static class AutocompletePacketData {
        String command;
        int argIndex;

        private AutocompletePacketData() {
        }
    }
}

