/*
 * Decompiled with CFR 0.152.
 */
package net.opanel;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.opanel.common.Constants;
import net.opanel.common.OPanelServer;
import net.opanel.config.ConfigManager;
import net.opanel.config.OPanelConfiguration;
import net.opanel.logger.Loggable;
import net.opanel.terminal.LogListenerManager;
import net.opanel.time.TPS;
import net.opanel.time.Uptimer;
import net.opanel.utils.Utils;
import net.opanel.web.WebServer;

public class OPanel {
    public static final String VERSION;
    public static final String JAVALIN_VERSION;
    public static final Path OPANEL_DIR_PATH;
    public static final Path TMP_DIR_PATH;
    public static final Path INITIAL_ACCESS_KEY_PATH;
    private final ConfigManager configManager;
    public final Loggable logger;
    private final Uptimer uptimer;
    private final WebServer webServer;
    private OPanelServer server;
    private LogListenerManager logListenerManager;

    public OPanel(ConfigManager configManager, Loggable logger) {
        this.configManager = configManager;
        this.logger = logger;
        this.uptimer = new Uptimer();
        try {
            this.init();
        }
        catch (IOException e) {
            logger.error("Failed to initialize OPanel directories: " + e.getMessage());
            throw new RuntimeException("OPanel initialization failed", e);
        }
        this.webServer = new WebServer(this);
    }

    private void init() throws IOException {
        File initialAccessKeyFile;
        File opanelDir = OPANEL_DIR_PATH.toFile();
        if (!opanelDir.exists() && !opanelDir.mkdir()) {
            throw new IOException("Cannot initialize opanel directory.");
        }
        File tmpDir = TMP_DIR_PATH.toFile();
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            throw new IOException("Cannot initialize opanel/.tmp directory.");
        }
        if (tmpDir.list().length > 0) {
            Utils.clearDirectoryRecursively(tmpDir.toPath());
        }
        if ((initialAccessKeyFile = INITIAL_ACCESS_KEY_PATH.toFile()).exists() && !initialAccessKeyFile.delete()) {
            throw new IOException("Cannot delete opanel/INITIAL_ACCESS_KEY.txt file, please delete it manually for your server security.");
        }
    }

    public void onTick() {
        TPS.onTick();
    }

    public OPanelConfiguration getConfig() {
        return this.configManager.get();
    }

    public void setConfig(OPanelConfiguration config) {
        this.configManager.set(config);
    }

    public void initializeAccessKey() {
        OPanelConfiguration config = this.getConfig();
        if (config.accessKey.isEmpty()) {
            String accessKey = Utils.generateRandomCharSequence(12, true);
            config.accessKey = Utils.md5(Utils.md5(accessKey));
            this.setConfig(config);
            try {
                Utils.writeTextFile(INITIAL_ACCESS_KEY_PATH, Constants.INITIAL_ACCESS_KEY_TEMPLATE + accessKey);
            }
            catch (IOException e) {
                this.logger.error("Failed to write the initial access key into INITIAL_ACCESS_KEY.txt: " + e.getMessage());
                throw new RuntimeException("Plaintext initial access key storage failed", e);
            }
            this.logger.warn("===========================OPanel===========================");
            this.logger.warn("Initial launching detected,");
            this.logger.warn("Check opanel/INITIAL_ACCESS_KEY.txt for the initial access key.");
            this.logger.warn("Remember to delete the file for your server security.");
            this.logger.warn("============================================================");
        }
        if (config.salt.isEmpty()) {
            config.salt = Utils.generateRandomCharSequence(6, true);
            this.setConfig(config);
        }
    }

    public Uptimer getUptimer() {
        return this.uptimer;
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setServer(OPanelServer server) {
        this.server = server;
    }

    public OPanelServer getServer() {
        return this.server;
    }

    public void setLogListenerManager(LogListenerManager manager) {
        this.logListenerManager = manager;
    }

    public LogListenerManager getLogListenerManager() {
        return this.logListenerManager;
    }

    public void stop() {
        if (this.webServer == null) {
            return;
        }
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            this.logger.error("Failed to stop web server: " + e.getMessage());
        }
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76\u00a7lOPanel \u00a7r\u00a7fStatus\n");
        sb.append("\u00a7r\u00a77Version: \u00a7f").append(VERSION).append("\n");
        sb.append("\u00a7r\u00a77Status: ").append(this.getWebServer().isRunning() ? "\u00a7aRunning" : "\u00a7cStopped").append("\n");
        sb.append("\u00a7r\u00a77Port: \u00a7f").append(this.getConfig().webServerPort).append("\n");
        sb.append("\u00a7r\u00a77Javalin Version: \u00a7f").append(JAVALIN_VERSION);
        return sb.toString();
    }

    static {
        OPANEL_DIR_PATH = Paths.get("", new String[0]).resolve("opanel");
        TMP_DIR_PATH = OPANEL_DIR_PATH.resolve(".tmp");
        INITIAL_ACCESS_KEY_PATH = OPANEL_DIR_PATH.resolve("INITIAL_ACCESS_KEY.txt");
        VERSION = Utils.readPropertyValueFromResources("opanel.properties", "version");
        JAVALIN_VERSION = Utils.readPropertyValueFromResources("META-INF/maven/io.javalin/javalin/pom.properties", "version");
    }
}

