/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.opanel.common.OPanelGameMode;
import net.opanel.event.EventManager;
import net.opanel.event.EventType;
import net.opanel.event.OPanelPlayerGameModeChangeEvent;
import net.opanel.event.OPanelPlayerJoinEvent;
import net.opanel.event.OPanelPlayerLeaveEvent;
import net.opanel.forge_1_21.ForgePlayer;

public class ForgeListener {
    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        EventManager.get().emit(EventType.PLAYER_JOIN, new OPanelPlayerJoinEvent(new ForgePlayer((ServerPlayer)event.getEntity())));
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        EventManager.get().emit(EventType.PLAYER_LEAVE, new OPanelPlayerLeaveEvent(new ForgePlayer((ServerPlayer)event.getEntity())));
    }

    @SubscribeEvent
    public void onPlayerGameModeChange(PlayerEvent.PlayerChangeGameModeEvent event) {
        GameType gamemode = event.getNewGameMode();
        EventManager.get().emit(EventType.PLAYER_GAMEMODE_CHANGE, new OPanelPlayerGameModeChangeEvent(new ForgePlayer((ServerPlayer)event.getEntity()), switch (gamemode) {
            case GameType.ADVENTURE -> OPanelGameMode.ADVENTURE;
            case GameType.SURVIVAL -> OPanelGameMode.SURVIVAL;
            case GameType.CREATIVE -> OPanelGameMode.CREATIVE;
            case GameType.SPECTATOR -> OPanelGameMode.SPECTATOR;
            default -> null;
        }));
    }
}

