/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.io.InputStream;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.ContentType;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.deps.javalin.http.UploadedFile;
import net.opanel.utils.Utils;

public class IconController
extends BaseController {
    public Handler getFavicon = ctx -> {
        OPanelServer server = this.plugin.getServer();
        byte[] favicon = server.getFavicon();
        if (favicon == null) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND);
            return;
        }
        this.sendContent(ctx, favicon, ContentType.IMAGE_PNG);
    };
    public Handler uploadFavicon = ctx -> {
        UploadedFile file = ctx.uploadedFile("file");
        if (file == null || file.size() <= 0L) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "File is missing.");
            return;
        }
        if (!file.filename().endsWith(".png")) {
            this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Server favicon should be a png.");
            return;
        }
        try (InputStream is = file.content();){
            byte[] iconBytes = is.readAllBytes();
            int[] dimensions = Utils.getImageDimensions(iconBytes);
            if (dimensions[0] != 64 || dimensions[1] != 64) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Server favicon should be 64*64 sized.");
                return;
            }
            this.server.setFavicon(iconBytes);
            this.sendResponse(ctx, HttpStatus.OK);
        }
    };

    public IconController(OPanel plugin) {
        super(plugin);
    }
}

