/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_helper;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.players.UserWhiteList;
import net.opanel.common.OPanelWhitelist;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.gson.GsonBuilder;
import net.opanel.utils.Utils;

public abstract class BaseForgeWhitelist
implements OPanelWhitelist {
    protected final UserWhiteList whitelist;
    protected final Path whitelistPath;

    public BaseForgeWhitelist(UserWhiteList whitelist) {
        this.whitelist = whitelist;
        this.whitelistPath = whitelist.m_11385_().toPath();
    }

    @Override
    public List<String> getNames() throws IOException {
        this.whitelist.m_11399_();
        return Arrays.asList(this.whitelist.m_5875_());
    }

    @Override
    public List<OPanelWhitelist.OPanelWhitelistEntry> getEntries() throws IOException {
        String jsonStr = Utils.readTextFile(this.whitelistPath);
        Type listType = new TypeToken<List<OPanelWhitelist.OPanelWhitelistEntry>>(){}.getType();
        Gson gson = new Gson();
        return (List)gson.fromJson(jsonStr, listType);
    }

    @Override
    public void write(List<OPanelWhitelist.OPanelWhitelistEntry> entries) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Utils.writeTextFile(this.whitelistPath, gson.toJson(entries));
        this.whitelist.m_11399_();
    }
}

