/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.CheckedSupplier;
import io.jsonwebtoken.impl.lang.DefaultRegistry;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.Providers;
import io.jsonwebtoken.impl.security.Randoms;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public class JcaTemplate {
    private static final List<InstanceFactory<?>> FACTORIES = Collections.of(new CipherFactory(), new KeyFactoryFactory(), new SecretKeyFactoryFactory(), new KeyGeneratorFactory(), new KeyPairGeneratorFactory(), new KeyAgreementFactory(), new MessageDigestFactory(), new SignatureFactory(), new MacFactory(), new AlgorithmParametersFactory(), new CertificateFactoryFactory());
    private static final Registry<Class<?>, InstanceFactory<?>> REGISTRY = new DefaultRegistry("JCA Instance Factory", "instance class", FACTORIES, new Function<InstanceFactory<?>, Class<?>>(){

        @Override
        public Class<?> apply(InstanceFactory<?> factory) {
            return factory.getInstanceClass();
        }
    });
    private final String jcaName;
    private final Provider provider;
    private final SecureRandom secureRandom;

    protected Provider findBouncyCastle() {
        return Providers.findBouncyCastle();
    }

    JcaTemplate(String jcaName) {
        this(jcaName, null);
    }

    JcaTemplate(String jcaName, Provider provider) {
        this(jcaName, provider, null);
    }

    JcaTemplate(String jcaName, Provider provider, SecureRandom secureRandom) {
        this.jcaName = Assert.hasText(jcaName, "jcaName string cannot be null or empty.");
        this.secureRandom = secureRandom != null ? secureRandom : Randoms.secureRandom();
        this.provider = provider;
    }

    private <T, R> R execute(Class<T> clazz, CheckedFunction<T, R> callback, Provider provider) throws Exception {
        InstanceFactory factory = (InstanceFactory)REGISTRY.get(clazz);
        Assert.notNull(factory, "Unsupported JCA instance class.");
        Object object = factory.get(this.jcaName, provider);
        T instance = Assert.isInstanceOf(clazz, object, "Factory instance does not match expected type.");
        return callback.apply(instance);
    }

    private <T> T execute(Class<?> clazz, CheckedSupplier<T> fn) throws SecurityException {
        try {
            return fn.get();
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            String msg = clazz.getSimpleName() + " callback execution failed: " + t.getMessage();
            throw new SecurityException(msg, t);
        }
    }

    private <T, R> R execute(final Class<T> clazz, final CheckedFunction<T, R> fn) throws SecurityException {
        return (R)this.execute(clazz, new CheckedSupplier<R>(){

            @Override
            public R get() throws Exception {
                return JcaTemplate.this.execute(clazz, fn, JcaTemplate.this.provider);
            }
        });
    }

    protected <T, R> R fallback(final Class<T> clazz, final CheckedFunction<T, R> callback) throws SecurityException {
        return (R)this.execute(clazz, new CheckedSupplier<R>(){

            @Override
            public R get() throws Exception {
                try {
                    return JcaTemplate.this.execute(clazz, callback, JcaTemplate.this.provider);
                }
                catch (Exception e) {
                    try {
                        Provider bc = JcaTemplate.this.findBouncyCastle();
                        if (bc != null) {
                            return JcaTemplate.this.execute(clazz, callback, bc);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw e;
                }
            }
        });
    }

    public <R> R withCipher(CheckedFunction<Cipher, R> fn) throws SecurityException {
        return this.execute(Cipher.class, fn);
    }

    public <R> R withKeyFactory(CheckedFunction<KeyFactory, R> fn) throws SecurityException {
        return this.execute(KeyFactory.class, fn);
    }

    public <R> R withSecretKeyFactory(CheckedFunction<SecretKeyFactory, R> fn) throws SecurityException {
        return this.execute(SecretKeyFactory.class, fn);
    }

    public <R> R withKeyGenerator(CheckedFunction<KeyGenerator, R> fn) throws SecurityException {
        return this.execute(KeyGenerator.class, fn);
    }

    public <R> R withKeyAgreement(CheckedFunction<KeyAgreement, R> fn) throws SecurityException {
        return this.execute(KeyAgreement.class, fn);
    }

    public <R> R withKeyPairGenerator(CheckedFunction<KeyPairGenerator, R> fn) throws SecurityException {
        return this.execute(KeyPairGenerator.class, fn);
    }

    public <R> R withMessageDigest(CheckedFunction<MessageDigest, R> fn) throws SecurityException {
        return this.execute(MessageDigest.class, fn);
    }

    public <R> R withSignature(CheckedFunction<Signature, R> fn) throws SecurityException {
        return this.execute(Signature.class, fn);
    }

    public <R> R withMac(CheckedFunction<Mac, R> fn) throws SecurityException {
        return this.execute(Mac.class, fn);
    }

    public <R> R withAlgorithmParameters(CheckedFunction<AlgorithmParameters, R> fn) throws SecurityException {
        return this.execute(AlgorithmParameters.class, fn);
    }

    public <R> R withCertificateFactory(CheckedFunction<CertificateFactory, R> fn) throws SecurityException {
        return this.execute(CertificateFactory.class, fn);
    }

    public SecretKey generateSecretKey(final int keyBitLength) {
        return this.withKeyGenerator(new CheckedFunction<KeyGenerator, SecretKey>(){

            @Override
            public SecretKey apply(KeyGenerator generator) {
                generator.init(keyBitLength, JcaTemplate.this.secureRandom);
                return generator.generateKey();
            }
        });
    }

    public KeyPair generateKeyPair() {
        return this.withKeyPairGenerator(new CheckedFunction<KeyPairGenerator, KeyPair>(){

            @Override
            public KeyPair apply(KeyPairGenerator gen) {
                return gen.generateKeyPair();
            }
        });
    }

    public KeyPair generateKeyPair(final int keyBitLength) {
        return this.withKeyPairGenerator(new CheckedFunction<KeyPairGenerator, KeyPair>(){

            @Override
            public KeyPair apply(KeyPairGenerator generator) {
                generator.initialize(keyBitLength, JcaTemplate.this.secureRandom);
                return generator.generateKeyPair();
            }
        });
    }

    public KeyPair generateKeyPair(final AlgorithmParameterSpec params) {
        return this.withKeyPairGenerator(new CheckedFunction<KeyPairGenerator, KeyPair>(){

            @Override
            public KeyPair apply(KeyPairGenerator generator) throws InvalidAlgorithmParameterException {
                generator.initialize(params, JcaTemplate.this.secureRandom);
                return generator.generateKeyPair();
            }
        });
    }

    public PublicKey generatePublic(final KeySpec spec) {
        return this.fallback(KeyFactory.class, new CheckedFunction<KeyFactory, PublicKey>(){

            @Override
            public PublicKey apply(KeyFactory keyFactory) throws Exception {
                return keyFactory.generatePublic(spec);
            }
        });
    }

    protected boolean isJdk11() {
        return System.getProperty("java.version").startsWith("11");
    }

    private boolean isJdk8213363Bug(InvalidKeySpecException e) {
        return this.isJdk11() && ("XDH".equals(this.jcaName) || "X25519".equals(this.jcaName) || "X448".equals(this.jcaName)) && e.getCause() instanceof InvalidKeyException && !Objects.isEmpty(e.getStackTrace()) && "sun.security.ec.XDHKeyFactory".equals(e.getStackTrace()[0].getClassName()) && "engineGeneratePrivate".equals(e.getStackTrace()[0].getMethodName());
    }

    private int getJdk8213363BugExpectedSize(InvalidKeyException e) {
        String msg = e.getMessage();
        String prefix = "key length must be ";
        if (Strings.hasText(msg) && msg.startsWith(prefix)) {
            String expectedSizeString = msg.substring(prefix.length());
            try {
                return Integer.parseInt(expectedSizeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private KeySpec respecIfNecessary(InvalidKeySpecException e, KeySpec spec) {
        InvalidKeyException cause;
        int size;
        if (!(spec instanceof PKCS8EncodedKeySpec)) {
            return null;
        }
        PKCS8EncodedKeySpec pkcs8Spec = (PKCS8EncodedKeySpec)spec;
        byte[] encoded = pkcs8Spec.getEncoded();
        if (this.isJdk8213363Bug(e) && ((size = this.getJdk8213363BugExpectedSize(cause = Assert.isInstanceOf(InvalidKeyException.class, e.getCause(), "Unexpected argument."))) == 32 || size == 56) && Bytes.length(encoded) >= size) {
            byte[] adjusted = new byte[size];
            System.arraycopy(encoded, encoded.length - size, adjusted, 0, size);
            EdwardsCurve curve = size == 32 ? EdwardsCurve.X25519 : EdwardsCurve.X448;
            return curve.privateKeySpec(adjusted, false);
        }
        return null;
    }

    protected PrivateKey generatePrivate(KeyFactory factory, KeySpec spec) throws InvalidKeySpecException {
        return factory.generatePrivate(spec);
    }

    public PrivateKey generatePrivate(final KeySpec spec) {
        return this.fallback(KeyFactory.class, new CheckedFunction<KeyFactory, PrivateKey>(){

            @Override
            public PrivateKey apply(KeyFactory keyFactory) throws Exception {
                try {
                    return JcaTemplate.this.generatePrivate(keyFactory, spec);
                }
                catch (InvalidKeySpecException e) {
                    KeySpec respec = JcaTemplate.this.respecIfNecessary(e, spec);
                    if (respec != null) {
                        return JcaTemplate.this.generatePrivate(keyFactory, respec);
                    }
                    throw e;
                }
            }
        });
    }

    public X509Certificate generateX509Certificate(final byte[] x509DerBytes) {
        return this.fallback(CertificateFactory.class, new CheckedFunction<CertificateFactory, X509Certificate>(){

            @Override
            public X509Certificate apply(CertificateFactory cf) throws CertificateException {
                InputStream is = Streams.of(x509DerBytes);
                return (X509Certificate)cf.generateCertificate(is);
            }
        });
    }

    private static class CertificateFactoryFactory
    extends JcaInstanceFactory<CertificateFactory> {
        CertificateFactoryFactory() {
            super(CertificateFactory.class);
        }

        @Override
        protected CertificateFactory doGet(String jcaName, Provider provider) throws Exception {
            return provider != null ? CertificateFactory.getInstance(jcaName, provider) : CertificateFactory.getInstance(jcaName);
        }
    }

    private static class AlgorithmParametersFactory
    extends JcaInstanceFactory<AlgorithmParameters> {
        AlgorithmParametersFactory() {
            super(AlgorithmParameters.class);
        }

        @Override
        protected AlgorithmParameters doGet(String jcaName, Provider provider) throws Exception {
            return provider != null ? AlgorithmParameters.getInstance(jcaName, provider) : AlgorithmParameters.getInstance(jcaName);
        }
    }

    private static class MacFactory
    extends JcaInstanceFactory<Mac> {
        MacFactory() {
            super(Mac.class);
        }

        @Override
        public Mac doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? Mac.getInstance(jcaName, provider) : Mac.getInstance(jcaName);
        }
    }

    private static class SignatureFactory
    extends JcaInstanceFactory<Signature> {
        SignatureFactory() {
            super(Signature.class);
        }

        @Override
        public Signature doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? Signature.getInstance(jcaName, provider) : Signature.getInstance(jcaName);
        }
    }

    private static class MessageDigestFactory
    extends JcaInstanceFactory<MessageDigest> {
        MessageDigestFactory() {
            super(MessageDigest.class);
        }

        @Override
        public MessageDigest doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? MessageDigest.getInstance(jcaName, provider) : MessageDigest.getInstance(jcaName);
        }
    }

    private static class KeyAgreementFactory
    extends JcaInstanceFactory<KeyAgreement> {
        KeyAgreementFactory() {
            super(KeyAgreement.class);
        }

        @Override
        public KeyAgreement doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? KeyAgreement.getInstance(jcaName, provider) : KeyAgreement.getInstance(jcaName);
        }
    }

    private static class KeyPairGeneratorFactory
    extends JcaInstanceFactory<KeyPairGenerator> {
        KeyPairGeneratorFactory() {
            super(KeyPairGenerator.class);
        }

        @Override
        public KeyPairGenerator doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? KeyPairGenerator.getInstance(jcaName, provider) : KeyPairGenerator.getInstance(jcaName);
        }
    }

    private static class KeyGeneratorFactory
    extends JcaInstanceFactory<KeyGenerator> {
        KeyGeneratorFactory() {
            super(KeyGenerator.class);
        }

        @Override
        public KeyGenerator doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? KeyGenerator.getInstance(jcaName, provider) : KeyGenerator.getInstance(jcaName);
        }
    }

    private static class SecretKeyFactoryFactory
    extends JcaInstanceFactory<SecretKeyFactory> {
        SecretKeyFactoryFactory() {
            super(SecretKeyFactory.class);
        }

        @Override
        public SecretKeyFactory doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? SecretKeyFactory.getInstance(jcaName, provider) : SecretKeyFactory.getInstance(jcaName);
        }
    }

    private static class KeyFactoryFactory
    extends JcaInstanceFactory<KeyFactory> {
        KeyFactoryFactory() {
            super(KeyFactory.class);
        }

        @Override
        public KeyFactory doGet(String jcaName, Provider provider) throws NoSuchAlgorithmException {
            return provider != null ? KeyFactory.getInstance(jcaName, provider) : KeyFactory.getInstance(jcaName);
        }
    }

    private static class CipherFactory
    extends JcaInstanceFactory<Cipher> {
        CipherFactory() {
            super(Cipher.class);
        }

        @Override
        public Cipher doGet(String jcaName, Provider provider) throws NoSuchPaddingException, NoSuchAlgorithmException {
            return provider != null ? Cipher.getInstance(jcaName, provider) : Cipher.getInstance(jcaName);
        }
    }

    private static abstract class JcaInstanceFactory<T>
    implements InstanceFactory<T> {
        private final Class<T> clazz;
        private final ConcurrentMap<String, Boolean> FALLBACK_ATTEMPTS = new ConcurrentHashMap<String, Boolean>();

        JcaInstanceFactory(Class<T> clazz) {
            this.clazz = Assert.notNull(clazz, "Class argument cannot be null.");
        }

        @Override
        public Class<T> getInstanceClass() {
            return this.clazz;
        }

        @Override
        public String getId() {
            return this.clazz.getSimpleName();
        }

        protected Provider findBouncyCastle() {
            return Providers.findBouncyCastle();
        }

        @Override
        public final T get(String jcaName, Provider specifiedProvider) throws Exception {
            Assert.hasText(jcaName, "jcaName cannot be null or empty.");
            Provider provider = specifiedProvider;
            Boolean attempted = (Boolean)this.FALLBACK_ATTEMPTS.get(jcaName);
            if (provider == null && attempted != null && attempted.booleanValue()) {
                provider = this.findBouncyCastle();
            }
            try {
                return this.doGet(jcaName, provider);
            }
            catch (NoSuchAlgorithmException nsa) {
                Provider fallback;
                if (specifiedProvider == null && attempted == null && (fallback = this.findBouncyCastle()) != null) {
                    try {
                        T value = this.doGet(jcaName, fallback);
                        this.FALLBACK_ATTEMPTS.putIfAbsent(jcaName, Boolean.TRUE);
                        return value;
                    }
                    catch (Throwable ignored) {
                        this.FALLBACK_ATTEMPTS.putIfAbsent(jcaName, Boolean.FALSE);
                    }
                }
                throw this.wrap(nsa, jcaName, specifiedProvider, null);
            }
            catch (Exception e) {
                throw this.wrap(e, jcaName, specifiedProvider, null);
            }
        }

        protected abstract T doGet(String var1, Provider var2) throws Exception;

        protected Exception wrap(Exception e, String jcaName, Provider specifiedProvider, Provider fallbackProvider) {
            String msg = "Unable to obtain '" + jcaName + "' " + this.getId() + " instance from ";
            msg = specifiedProvider != null ? msg + "specified '" + specifiedProvider + "' Provider" : msg + "default JCA Provider";
            if (fallbackProvider != null) {
                msg = msg + " or fallback '" + fallbackProvider + "' Provider";
            }
            msg = msg + ": " + e.getMessage();
            return this.wrap(msg, e);
        }

        protected Exception wrap(String msg, Exception cause) {
            if (Signature.class.isAssignableFrom(this.clazz) || Mac.class.isAssignableFrom(this.clazz)) {
                return new SignatureException(msg, cause);
            }
            return new SecurityException(msg, cause);
        }
    }

    private static interface InstanceFactory<T>
    extends Identifiable {
        public Class<T> getInstanceClass();

        public T get(String var1, Provider var2) throws Exception;
    }
}

