/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_helper;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelPlayer;

public abstract class BaseForgeOfflinePlayer
implements OPanelPlayer {
    protected static final long NBT_TRACKER_SIZE = 0x200000L;
    protected final PlayerList playerManager;
    protected final Path playerDataPath;
    protected final UUID uuid;

    public BaseForgeOfflinePlayer(MinecraftServer server, UUID uuid) {
        this.playerManager = server.m_6846_();
        this.playerDataPath = server.m_129843_(LevelResource.f_78176_).resolve(String.valueOf(uuid) + ".dat");
        this.uuid = uuid;
        if (!Files.exists(this.playerDataPath, new LinkOption[0])) {
            throw new NullPointerException("Player data file for UUID " + String.valueOf(uuid) + " unavailable.");
        }
        ServerPlayer serverPlayer = this.playerManager.m_11259_(uuid);
        if (serverPlayer != null && !serverPlayer.m_9232_()) {
            throw new IllegalStateException("The provided player is online, please use ForgePlayer class instead.");
        }
    }

    @Override
    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public void kick(String reason) {
        throw new IllegalStateException("The player is offline.");
    }

    @Override
    public int getPing() {
        throw new IllegalStateException("The player is offline.");
    }
}

