/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.LocatorAdapter;
import io.jsonwebtoken.impl.lang.Function;
import java.security.Key;

public class ConstantKeyLocator
extends LocatorAdapter<Key>
implements Function<Header, Key> {
    private final Key jwsKey;
    private final Key jweKey;

    public ConstantKeyLocator(Key jwsKey, Key jweKey) {
        this.jwsKey = jwsKey;
        this.jweKey = jweKey;
    }

    @Override
    protected Key locate(JwsHeader header) {
        return this.jwsKey;
    }

    @Override
    protected Key locate(JweHeader header) {
        return this.jweKey;
    }

    @Override
    public Key apply(Header header) {
        return (Key)this.locate(header);
    }
}

