/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.folia_1_20;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import net.opanel.bukkit_helper.BaseBukkitServer;
import net.opanel.bukkit_helper.BukkitUtils;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.common.ServerType;
import net.opanel.common.features.BukkitConfigFeature;
import net.opanel.folia_1_20.FoliaOfflinePlayer;
import net.opanel.folia_1_20.FoliaPlayer;
import net.opanel.folia_1_20.FoliaSave;
import net.opanel.folia_1_20.FoliaWhitelist;
import net.opanel.folia_1_20.Main;
import org.bukkit.GameRule;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class FoliaServer
extends BaseBukkitServer
implements OPanelServer,
BukkitConfigFeature {
    public FoliaServer(Main plugin, Server server) {
        super(plugin, server);
    }

    @Override
    public ServerType getServerType() {
        return ServerType.FOLIA;
    }

    @Override
    public void setFavicon(byte[] iconBytes) throws IOException {
        super.setFavicon(iconBytes);
        try {
            Method loadIconMethod = this.server.getClass().getDeclaredMethod("loadIcon", new Class[0]);
            loadIconMethod.setAccessible(true);
            loadIconMethod.invoke((Object)this.server, new Object[0]);
        }
        catch (Exception e) {
            ((Main)this.plugin).LOGGER.warning("Cannot reload server favicon.");
        }
    }

    @Override
    public void setMotd(String motd) throws IOException {
        this.server.setMotd(motd);
        String formatted = motd.replaceAll("\n", Matcher.quoteReplacement("\\n"));
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("motd=.+", Matcher.quoteReplacement("motd=" + formatted)));
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> !path.toString().endsWith("_nether") && !path.toString().endsWith("_the_end") && Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                FoliaSave save = new FoliaSave((Main)this.plugin, this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || savePath.toString().endsWith("_nether") || savePath.toString().endsWith("_the_end") || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new FoliaSave((Main)this.plugin, this.server, savePath.toAbsolutePath());
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        Collection players = this.server.getOnlinePlayers();
        for (Player serverPlayer : players) {
            FoliaPlayer player = new FoliaPlayer((Main)this.plugin, serverPlayer);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        OfflinePlayer[] players;
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        for (OfflinePlayer offlinePlayer : players = this.server.getOfflinePlayers()) {
            if (offlinePlayer.isOnline()) {
                Player serverPlayer = offlinePlayer.getPlayer();
                if (serverPlayer == null) continue;
                list.add(new FoliaPlayer((Main)this.plugin, serverPlayer));
                continue;
            }
            list.add(new FoliaOfflinePlayer((Main)this.plugin, this.server, offlinePlayer));
        }
        return list;
    }

    @Override
    public void banIp(String ip2) {
        if (this.server.getIPBans().contains(ip2)) {
            return;
        }
        this.server.banIP(ip2);
    }

    @Override
    public void pardonIp(String ip2) {
        if (!this.server.getIPBans().contains(ip2)) {
            return;
        }
        this.server.unbanIP(ip2);
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new FoliaWhitelist((Main)this.plugin, this.server, (Set<OfflinePlayer>)this.server.getWhitelistedPlayers());
    }

    @Override
    public List<String> getCommandTabList(int argIndex, String command) {
        if (argIndex == 1) {
            return this.getCommands();
        }
        ArrayList<String> tabList = new ArrayList<String>();
        String[] args2 = command.split(" ");
        try {
            CommandDispatcher<?> dispatcher = BukkitUtils.getCommandDispatcher(true);
            RootCommandNode currentNode = dispatcher.getRoot();
            for (int i = 0; i <= args2.length && currentNode != null; currentNode = currentNode.getChild(args2[i]), ++i) {
                if (i + 1 == argIndex) {
                    for (CommandNode subNode : currentNode.getChildren()) {
                        tabList.add(subNode.getName());
                    }
                } else if (i != args2.length) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tabList;
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        World world = (World)this.server.getWorlds().get(0);
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : world.getGameRules()) {
            GameRule rule = GameRule.getByName((String)key);
            if (rule == null) continue;
            gamerules.put(key, world.getGameRuleValue(rule));
        }
        return gamerules;
    }

    @Override
    public void setGamerules(HashMap<String, Object> gamerules) {
        HashMap<String, Object> currentGamerules = this.getGamerules();
        this.runner.runTask(() -> {
            World world = (World)this.server.getWorlds().get(0);
            gamerules.forEach((key, value) -> {
                if (value == null) {
                    return;
                }
                Object currentValue = currentGamerules.get(key);
                if (value.equals(currentValue)) {
                    return;
                }
                GameRule rule = GameRule.getByName((String)key);
                if (rule == null) {
                    return;
                }
                if (rule.getType().equals(Boolean.class)) {
                    world.setGameRule(rule, (Object)((Boolean)value));
                } else if (rule.getType().equals(Integer.class)) {
                    int n = ((Number)value).intValue();
                    world.setGameRule(rule, (Object)n);
                } else {
                    this.sendServerCommand("gamerule " + key + " " + String.valueOf(value));
                }
            });
        });
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException("Folia doesn't support reload operation");
    }
}

