/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.time.TPS;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;

public class MonitorController
extends BaseController {
    public Handler getMonitor = ctx -> {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("cpu", this.getCpuRate());
        obj.put("mem", this.getMemRate());
        obj.put("tps", TPS.getRecentTPS());
        this.sendResponse(ctx, obj);
    };

    public MonitorController(OPanel plugin) {
        super(plugin);
    }

    private double getCpuRate() {
        SystemInfo si = new SystemInfo();
        double load = si.getHardware().getProcessor().getSystemCpuLoad(500L) * 100.0;
        return Math.round(load);
    }

    private double getMemRate() {
        SystemInfo si = new SystemInfo();
        GlobalMemory gm = si.getHardware().getMemory();
        long total = gm.getTotal();
        long avail = gm.getAvailable();
        long used = total - avail;
        double rate = (double)used / (double)total * 100.0;
        return Math.round(rate);
    }
}

