/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;

public class IdLocator<H extends Header, R extends Identifiable>
implements Locator<R>,
Function<H, R> {
    private final Parameter<String> param;
    private final Registry<String, R> registry;
    private final String algType;
    private final String behavior;
    private final String requiredMsg;

    public IdLocator(Parameter<String> param, Registry<String, R> registry, String algType, String behavior, String requiredExceptionMessage) {
        this.param = Assert.notNull(param, "Header param cannot be null.");
        this.registry = Assert.notNull(registry, "Registry cannot be null.");
        this.algType = Assert.hasText(algType, "algType cannot be null or empty.");
        this.behavior = Assert.hasText(behavior, "behavior cannot be null or empty.");
        this.requiredMsg = Strings.clean(requiredExceptionMessage);
    }

    @Override
    public R locate(Header header) {
        String id;
        Object val = header.get(this.param.getId());
        String string = id = val != null ? val.toString() : null;
        if (!Strings.hasText(id)) {
            if (this.requiredMsg != null) {
                throw new MalformedJwtException(this.requiredMsg);
            }
            return null;
        }
        try {
            return (R)((Identifiable)this.registry.forKey(id));
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Unsupported ").append(DefaultHeader.nameOf(header)).append(" ").append(this.param).append(" value '").append(id).append("'");
            if (this.registry.isEmpty()) {
                sb.append(": ").append(this.behavior).append(" is disabled (no ").append(this.algType).append(" algorithms have been configured)");
            }
            sb.append(".");
            String msg = sb.toString();
            throw new UnsupportedJwtException(msg, e);
        }
    }

    @Override
    public R apply(H header) {
        return (R)this.locate((Header)header);
    }
}

