/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.folia_1_21;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import net.opanel.OPanel;
import net.opanel.deps.nbtapi.NBT;
import net.opanel.folia_1_21.FoliaListener;
import net.opanel.folia_1_21.FoliaServer;
import net.opanel.folia_1_21.LoggerImpl;
import net.opanel.folia_1_21.command.OPanelCommand;
import net.opanel.folia_1_21.config.ConfigManagerImpl;
import net.opanel.folia_1_21.terminal.LogListenerManagerImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
extends JavaPlugin
implements Listener {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public final java.util.logging.Logger LOGGER = this.getLogger();
    public OPanel instance;
    private ScheduledTask serverTickListener;
    private LogListenerManagerImpl logListenerAppender;

    public void onEnable() {
        if (!NBT.preloadApi()) {
            this.LOGGER.warning("Cannot start OPanel plugin: NBT-API is not initialized properly.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        LoggerImpl logger = new LoggerImpl(this.LOGGER);
        this.saveDefaultConfig();
        this.instance = new OPanel(new ConfigManagerImpl(this.getConfig(), this), logger);
        this.initLogListenerAppender();
        this.initServerTickListener();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new FoliaListener(this), (Plugin)this);
        this.getCommand("opanel").setExecutor((CommandExecutor)new OPanelCommand(this.instance));
    }

    public void onDisable() {
        try {
            if (this.logListenerAppender != null) {
                this.disposeLogListenerAppender();
            }
        }
        catch (Exception e) {
            log.error("Failed to dispose log listener appender: " + e.getMessage());
        }
        try {
            if (this.serverTickListener != null && !this.serverTickListener.isCancelled()) {
                this.serverTickListener.cancel();
            }
        }
        catch (Exception e) {
            log.error("Failed to cancel server tick listener: " + e.getMessage());
        }
        try {
            if (this.instance != null) {
                this.instance.stop();
            }
        }
        catch (Exception e) {
            log.error("Failed to stop OPanel instance: " + e.getMessage());
        }
    }

    private void initLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        this.logListenerAppender = LogListenerManagerImpl.createAppender("LogListenerAppender", true);
        this.logListenerAppender.start();
        logger.addAppender((Appender)this.logListenerAppender);
        this.instance.setLogListenerManager(this.logListenerAppender);
    }

    private void disposeLogListenerAppender() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.removeAppender((Appender)this.logListenerAppender);
        this.logListenerAppender.clearListeners();
    }

    private void initServerTickListener() {
        this.serverTickListener = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, task -> this.instance.onTick(), 1L, 1L);
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        this.instance.setServer(new FoliaServer(this, this.getServer()));
        try {
            this.instance.getWebServer().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(Runnable task) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            Bukkit.getGlobalRegionScheduler().run((Plugin)this, scheduledTask -> {
                task.run();
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void runTaskLater(Runnable task, long delay) {
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this, scheduledTask -> task.run(), delay);
    }
}

