/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import net.opanel.OPanel;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.controller.BaseController;
import net.opanel.controller.api.DownloadController;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.deps.javalin.http.UploadedFile;
import net.opanel.utils.Utils;
import net.opanel.utils.ZipUtility;

public class SavesController
extends BaseController {
    private final DownloadController downloadController = this.getControllerInstance(DownloadController.class);
    public Handler getSaves = ctx -> {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        ArrayList saves = new ArrayList();
        for (OPanelSave save : this.server.getSaves()) {
            HashMap<String, Object> saveInfo = new HashMap<String, Object>();
            saveInfo.put("name", save.getName());
            saveInfo.put("displayName", Utils.stringToBase64(save.getDisplayName()));
            saveInfo.put("path", save.getPath().toString());
            saveInfo.put("size", save.getSize());
            saveInfo.put("isRunning", save.isRunning());
            saveInfo.put("isCurrent", save.isCurrent());
            saveInfo.put("defaultGameMode", save.getDefaultGameMode().getName());
            saves.add(saveInfo);
        }
        obj.put("saves", saves);
        this.sendResponse(ctx, obj);
    };
    public Handler downloadSave = ctx -> {
        String saveName = ctx.pathParam("saveName");
        OPanelSave save = this.server.getSave(saveName);
        if (save == null) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "Cannot find the specified save.");
            return;
        }
        if (save.isRunning()) {
            this.server.saveAll();
        }
        Path savePath = save.getPath();
        Path zipPath = OPanel.TMP_DIR_PATH.resolve(UUID.randomUUID() + ".zip");
        try {
            if (this.server.getServerType().isBukkitSeries()) {
                Path netherDim = Paths.get("", new String[0]).resolve(saveName + "_nether/DIM-1");
                Path theEndDim = Paths.get("", new String[0]).resolve(saveName + "_the_end/DIM1");
                if (Files.exists(netherDim, new LinkOption[0])) {
                    Utils.copyDirectoryRecursively(netherDim, savePath.resolve("DIM-1"));
                }
                if (Files.exists(theEndDim, new LinkOption[0])) {
                    Utils.copyDirectoryRecursively(theEndDim, savePath.resolve("DIM1"));
                }
            }
            ZipUtility.zip(savePath, zipPath);
            String downloadId = this.downloadController.registerPath(zipPath, () -> {
                Files.delete(zipPath);
                if (this.server.getServerType().isBukkitSeries()) {
                    if (Files.exists(savePath.resolve("DIM-1"), new LinkOption[0])) {
                        Utils.deleteDirectoryRecursively(savePath.resolve("DIM-1"));
                    }
                    if (Files.exists(savePath.resolve("DIM1"), new LinkOption[0])) {
                        Utils.deleteDirectoryRecursively(savePath.resolve("DIM1"));
                    }
                }
            });
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("download", downloadId);
            this.sendResponse(ctx, obj);
        }
        catch (Exception e) {
            if (Files.exists(zipPath, new LinkOption[0])) {
                Files.delete(zipPath);
            }
            if (this.server.getServerType().isBukkitSeries()) {
                if (Files.exists(savePath.resolve("DIM-1"), new LinkOption[0])) {
                    Utils.deleteDirectoryRecursively(savePath.resolve("DIM-1"));
                }
                if (Files.exists(savePath.resolve("DIM1"), new LinkOption[0])) {
                    Utils.deleteDirectoryRecursively(savePath.resolve("DIM1"));
                }
            }
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler uploadSave = ctx -> {
        try {
            UploadedFile file = ctx.uploadedFile("file");
            if (file == null || file.size() <= 0L) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "File is missing.");
                return;
            }
            String fileName = file.filename();
            if (!fileName.endsWith(".zip")) {
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Save file should be a zip.");
                return;
            }
            Path targetPath = Paths.get("", new String[0]).resolve(fileName.replaceAll(".zip", ""));
            if (Files.exists(targetPath, new LinkOption[0])) {
                this.sendResponse(ctx, HttpStatus.CONFLICT, "Save name conflict.");
                return;
            }
            Path filePath = OPanel.TMP_DIR_PATH.resolve(fileName);
            try (InputStream is = file.content();){
                Files.copy(is, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
            ZipUtility.unzip(filePath, targetPath);
            Files.delete(filePath);
            if (!Files.exists(targetPath.resolve("level.dat"), new LinkOption[0])) {
                Path folderInside = targetPath.resolve(targetPath.getFileName()).toAbsolutePath();
                if (!Files.exists(folderInside, new LinkOption[0])) {
                    Utils.deleteDirectoryRecursively(targetPath);
                    this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Invalid save file.");
                    return;
                }
                try (Stream<Path> stream = Files.list(folderInside);){
                    stream.forEach(path -> {
                        try {
                            Utils.copyDirectoryRecursively(path, targetPath.resolve(path.getFileName()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                Utils.deleteDirectoryRecursively(folderInside);
            }
            if (!Files.exists(targetPath.resolve("level.dat"), new LinkOption[0])) {
                Utils.deleteDirectoryRecursively(targetPath);
                this.sendResponse(ctx, HttpStatus.BAD_REQUEST, "Invalid save file.");
                return;
            }
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (ZipException e) {
            this.plugin.logger.warn("An illegal save zip is detected! This may cause a zip slip, so it is blocked from unzipping to the server.");
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "Invalid save file, zip slip detected.");
            Utils.clearDirectoryRecursively(OPanel.TMP_DIR_PATH);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler editSave = ctx -> {
        String saveName = ctx.pathParam("saveName");
        SaveEditRequestBodyType reqBody = ctx.bodyAsClass(SaveEditRequestBodyType.class);
        try {
            OPanelSave save = this.server.getSave(saveName);
            save.setDisplayName(Utils.base64ToString(reqBody.displayName));
            save.setDefaultGameMode(OPanelGameMode.fromString(reqBody.defaultGameMode));
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };
    public Handler deleteSave = ctx -> {
        String saveName = ctx.pathParam("saveName");
        OPanelSave save = this.server.getSave(saveName);
        if (save.isRunning() || save.isCurrent()) {
            this.sendResponse(ctx, HttpStatus.FORBIDDEN, "You cannot delete current save.");
            return;
        }
        try {
            save.delete();
            this.sendResponse(ctx, HttpStatus.OK);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    };

    public SavesController(OPanel plugin) {
        super(plugin);
    }

    private static class SaveEditRequestBodyType {
        String displayName;
        String defaultGameMode;

        private SaveEditRequestBodyType() {
        }
    }
}

