/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.controller.api;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import net.opanel.OPanel;
import net.opanel.controller.BaseController;
import net.opanel.deps.javalin.http.ContentType;
import net.opanel.deps.javalin.http.Handler;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.utils.Callback;
import net.opanel.utils.Utils;

public class DownloadController
extends BaseController {
    private static final int idLength = 16;
    private final ConcurrentHashMap<String, Path> pathMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, byte[]> contentMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Callback> callbackMap = new ConcurrentHashMap();
    public Handler downloadFile = ctx -> {
        String id = ctx.pathParam("id");
        if (!this.pathMap.containsKey(id) && !this.contentMap.containsKey(id)) {
            this.sendResponse(ctx, HttpStatus.NOT_FOUND, "File not found.");
            return;
        }
        String fileName = ctx.pathParam("fileName");
        if (this.pathMap.containsKey(id)) {
            this.sendContent(ctx, Utils.readFile(this.pathMap.get(id)), ContentType.APPLICATION_OCTET_STREAM, fileName);
            if (this.callbackMap.containsKey(id)) {
                Callback cb = this.callbackMap.get(id);
                cb.action();
                this.callbackMap.remove(id);
            }
            this.pathMap.remove(id);
        } else {
            this.sendContent(ctx, this.contentMap.get(id), ContentType.APPLICATION_OCTET_STREAM, fileName);
            this.contentMap.remove(id);
        }
    };

    public DownloadController(OPanel plugin) {
        super(plugin);
    }

    public String registerPath(Path path) {
        return this.registerPath(path, () -> {});
    }

    public String registerPath(Path path, Callback afterDownloading) {
        String id = this.generateUniqueId();
        this.pathMap.put(id, path);
        this.callbackMap.put(id, afterDownloading);
        return id;
    }

    public String registerContent(String content) {
        return this.registerContent(content.getBytes(StandardCharsets.UTF_8));
    }

    public String registerContent(byte[] bytes) {
        String id = this.generateUniqueId();
        this.contentMap.put(id, bytes);
        return id;
    }

    private String generateUniqueId() {
        String id = Utils.generateRandomCharSequence(16, false);
        while (this.pathMap.containsKey(id) || this.contentMap.containsKey(id)) {
            id = Utils.generateRandomCharSequence(16, false);
        }
        return id;
    }
}

