/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_3;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;

public class ForgeSave
implements OPanelSave {
    private final MinecraftServer server;
    private final Path savePath;
    private CompoundTag nbt;

    public ForgeSave(MinecraftServer server, Path path) {
        this.server = server;
        this.savePath = path;
        try {
            this.nbt = NbtIo.m_128939_((Path)this.savePath.resolve("level.dat"), (NbtAccounter)NbtAccounter.m_301677_((long)0x200000L)).m_128469_("Data");
            if (this.nbt.m_128456_()) {
                throw new IOException("Cannot find a valid level.dat");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveNbt() throws IOException {
        CompoundTag dataNbt = new CompoundTag();
        dataNbt.m_128365_("Data", (Tag)this.nbt);
        NbtIo.m_128944_((CompoundTag)dataNbt, (Path)this.savePath.resolve("level.dat"));
    }

    @Override
    public String getName() {
        return this.savePath.getFileName().toString();
    }

    @Override
    public String getDisplayName() {
        return this.nbt.m_128461_("LevelName").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.m_128359_("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public Path getPath() {
        return this.savePath.toAbsolutePath();
    }

    @Override
    public long getSize() throws IOException {
        return Utils.getDirectorySize(this.savePath);
    }

    @Override
    public boolean isRunning() {
        return this.server.m_129843_(LevelResource.f_78178_).getParent().getFileName().toString().equals(this.getName());
    }

    @Override
    public boolean isCurrent() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(OPanelServer.serverPropertiesPath.toFile()));
        return properties.getProperty("level-name").replaceAll("\u00c2", "").equals(this.getName());
    }

    @Override
    public void setToCurrent() throws IOException {
        if (this.isCurrent()) {
            return;
        }
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("level-name=.+", "level-name=" + this.getName()));
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        GameType gamemode = GameType.m_46393_((int)this.nbt.m_128451_("GameType"));
        switch (gamemode) {
            case ADVENTURE: {
                return OPanelGameMode.ADVENTURE;
            }
            case SURVIVAL: {
                return OPanelGameMode.SURVIVAL;
            }
            case CREATIVE: {
                return OPanelGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        switch (gamemode) {
            case ADVENTURE: {
                this.nbt.m_128405_("GameType", 2);
                break;
            }
            case SURVIVAL: {
                this.nbt.m_128405_("GameType", 0);
                break;
            }
            case CREATIVE: {
                this.nbt.m_128405_("GameType", 1);
                break;
            }
            case SPECTATOR: {
                this.nbt.m_128405_("GameType", 3);
            }
        }
        this.saveNbt();
    }

    @Override
    public void delete() throws IOException {
        Utils.deleteDirectoryRecursively(this.savePath);
    }
}

