/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import java.io.IOException;
import net.opanel.OPanel;
import net.opanel.api.AuthController;
import net.opanel.api.BannedIpsController;
import net.opanel.api.ControlController;
import net.opanel.api.GamerulesController;
import net.opanel.api.IconController;
import net.opanel.api.InfoController;
import net.opanel.api.LogsController;
import net.opanel.api.MonitorController;
import net.opanel.api.PlayersController;
import net.opanel.api.SavesController;
import net.opanel.api.SecurityController;
import net.opanel.api.VersionController;
import net.opanel.api.WhitelistController;
import net.opanel.deps.gson.Gson;
import net.opanel.deps.javalin.Javalin;
import net.opanel.deps.javalin.apibuilder.ApiBuilder;
import net.opanel.deps.javalin.config.SizeUnit;
import net.opanel.deps.javalin.http.HttpStatus;
import net.opanel.deps.javalin.jetty.JettyServer;
import net.opanel.deps.javalin.json.JavalinGson;
import net.opanel.deps.javalin.util.JavalinLogger;
import net.opanel.deps.javalin.websocket.WsConfig;
import net.opanel.terminal.TerminalEndpoint;
import net.opanel.web.BeforeController;
import net.opanel.web.ErrorController;

public class WebServer {
    public final int PORT;
    private final OPanel plugin;
    private Javalin app;

    public WebServer(OPanel plugin) {
        this.plugin = plugin;
        this.PORT = plugin.getConfig().webServerPort;
        JavalinLogger.enabled = false;
    }

    public void start() throws Exception {
        this.app = Javalin.create(config -> {
            config.showJavalinBanner = false;
            config.jsonMapper(new JavalinGson(new Gson()));
            config.plugins.enableCors(cors -> cors.add(it -> it.allowHost("http://localhost:3001", new String[0])));
            config.jetty.multipartConfig.cacheDirectory(OPanel.TMP_DIR_PATH.toString());
            config.jetty.multipartConfig.maxInMemoryFileSize(10, SizeUnit.MB);
            config.staticFiles.add(staticFiles -> {
                staticFiles.hostedPath = "/";
                staticFiles.directory = "/web";
            });
        });
        this.app.ws("/terminal", ws -> new TerminalEndpoint((WsConfig)ws, this.plugin));
        BeforeController beforeController = new BeforeController(this.plugin);
        ErrorController errorController = new ErrorController(this.plugin);
        AuthController authController = new AuthController(this.plugin);
        BannedIpsController bannedIpsController = new BannedIpsController(this.plugin);
        ControlController controlController = new ControlController(this.plugin);
        GamerulesController gamerulesController = new GamerulesController(this.plugin);
        IconController iconController = new IconController(this.plugin);
        InfoController infoController = new InfoController(this.plugin);
        LogsController logsController = new LogsController(this.plugin);
        MonitorController monitorController = new MonitorController(this.plugin);
        PlayersController playersController = new PlayersController(this.plugin);
        SavesController savesController = new SavesController(this.plugin);
        SecurityController securityController = new SecurityController(this.plugin);
        VersionController versionController = new VersionController(this.plugin);
        WhitelistController whitelistController = new WhitelistController(this.plugin);
        this.app.before("/*", beforeController.beforeAll);
        this.app.before("/*", beforeController.handleRsc);
        this.app.before("/*", beforeController.handleFonts);
        this.app.routes(() -> ApiBuilder.path("api", () -> {
            ApiBuilder.before("/*", beforeController.authCookie);
            ApiBuilder.path("auth", () -> {
                ApiBuilder.get("/", authController.getCram);
                ApiBuilder.post("/", authController.validateCram);
            });
            ApiBuilder.path("banned-ips", () -> {
                ApiBuilder.get("/", bannedIpsController.getBannedIps);
                ApiBuilder.post("add", bannedIpsController.banIp);
                ApiBuilder.post("remove", bannedIpsController.pardonIp);
            });
            ApiBuilder.path("control", () -> {
                ApiBuilder.get("properties", controlController.getServerProperties);
                ApiBuilder.post("properties", controlController.setServerProperties);
                ApiBuilder.get("code-of-conduct", controlController.getCodeOfConducts);
                ApiBuilder.post("code-of-conduct", controlController.changeCodeOfConduct);
                ApiBuilder.delete("code-of-conduct", controlController.removeCodeOfConduct);
                ApiBuilder.post("stop", controlController.stopServer);
                ApiBuilder.post("reload", controlController.reloadServer);
                ApiBuilder.post("world", controlController.switchSave);
            });
            ApiBuilder.path("gamerules", () -> {
                ApiBuilder.get("/", gamerulesController.getGamerules);
                ApiBuilder.post("/", gamerulesController.changeGamerule);
            });
            ApiBuilder.path("icon", () -> {
                ApiBuilder.get("/", iconController.getFavicon);
                ApiBuilder.post("/", iconController.uploadFavicon);
            });
            ApiBuilder.path("info", () -> {
                ApiBuilder.get("/", infoController.getServerInfo);
                ApiBuilder.post("motd", infoController.setMotd);
            });
            ApiBuilder.path("logs", () -> {
                ApiBuilder.get("/", logsController.getLogFileList);
                ApiBuilder.get("{fileName}", logsController.getLogContent);
                ApiBuilder.delete("/", logsController.clearLogs);
                ApiBuilder.delete("{fileName}", logsController.deleteLog);
            });
            ApiBuilder.get("monitor", monitorController.getMonitor);
            ApiBuilder.path("players", () -> {
                ApiBuilder.get("/", playersController.getPlayers);
                ApiBuilder.delete("/", playersController.deletePlayerData);
                ApiBuilder.post("op", playersController.giveOp);
                ApiBuilder.post("deop", playersController.depriveOp);
                ApiBuilder.post("kick", playersController.kickPlayer);
                ApiBuilder.post("ban", playersController.banPlayer);
                ApiBuilder.post("pardon", playersController.pardonPlayer);
                ApiBuilder.post("gamemode", playersController.setGamemode);
            });
            ApiBuilder.path("saves", () -> {
                ApiBuilder.get("/", savesController.getSaves);
                ApiBuilder.post("/", savesController.uploadSave);
                ApiBuilder.get("{saveName}", savesController.downloadSave);
                ApiBuilder.post("{saveName}", savesController.editSave);
                ApiBuilder.delete("{saveName}", savesController.deleteSave);
            });
            ApiBuilder.post("security", securityController.updateAccessKey);
            ApiBuilder.get("version", versionController.getVersionInfo);
            ApiBuilder.path("whitelist", () -> {
                ApiBuilder.get("/", whitelistController.getWhitelist);
                ApiBuilder.post("enable", whitelistController.enableWhitelist);
                ApiBuilder.post("disable", whitelistController.disableWhitelist);
                ApiBuilder.post("write", whitelistController.writeWhitelist);
                ApiBuilder.post("add", whitelistController.addWhitelistEntry);
                ApiBuilder.post("remove", whitelistController.removeWhitelistEntry);
            });
        }));
        this.app.error(HttpStatus.NOT_FOUND, errorController.notFound);
        this.app.start(this.PORT);
        this.plugin.logger.info("OPanel web server is ready on port " + this.PORT);
        this.plugin.initializeAccessKey();
        this.app.events(event -> event.serverStopping(() -> {
            try {
                TerminalEndpoint.closeAllSessions();
            }
            catch (IOException e) {
                this.plugin.logger.error("Failed to close WebSocket sessions: " + e.getMessage());
            }
        }));
    }

    public void stop() throws Exception {
        if (this.isRunning()) {
            this.app.stop();
            this.plugin.logger.info("Web server is stopped.");
        }
    }

    public boolean isRunning() {
        JettyServer jettyServer = this.app.jettyServer();
        return this.app != null && jettyServer != null && jettyServer.started;
    }
}

