/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.spigot_1_21_9;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import net.opanel.ServerType;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.common.features.CodeOfConductFeature;
import net.opanel.spigot_1_21_9.Main;
import net.opanel.spigot_1_21_9.SpigotOfflinePlayer;
import net.opanel.spigot_1_21_9.SpigotPlayer;
import net.opanel.spigot_1_21_9.SpigotSave;
import net.opanel.spigot_1_21_9.SpigotWhitelist;
import net.opanel.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;

public class SpigotServer
implements OPanelServer,
CodeOfConductFeature {
    private final Main plugin;
    private final Server server;

    public SpigotServer(Main plugin, Server server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Override
    public ServerType getServerType() {
        if (Utils.hasClass("com.destroystokyo.paper.PaperConfig")) {
            return ServerType.PAPER;
        }
        if (Utils.hasClass("org.bukkit.entity.Player$Spigot")) {
            return ServerType.SPIGOT;
        }
        return ServerType.BUKKIT;
    }

    @Override
    public void setFavicon(byte[] iconBytes) throws IOException {
        OPanelServer.super.setFavicon(iconBytes);
        try {
            Method loadIconMethod = this.server.getClass().getDeclaredMethod("loadIcon", new Class[0]);
            loadIconMethod.setAccessible(true);
            loadIconMethod.invoke((Object)this.server, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.LOGGER.warning("Cannot reload server favicon.");
        }
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public void setMotd(String motd) throws IOException {
        this.server.setMotd(motd);
        String formatted = motd.replaceAll("\n", Matcher.quoteReplacement("\\n"));
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("motd=.+", Matcher.quoteReplacement("motd=" + formatted)));
    }

    @Override
    public String getVersion() {
        return this.server.getBukkitVersion().split("-")[0];
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> !path.toString().endsWith("_nether") && !path.toString().endsWith("_the_end") && Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                SpigotSave save = new SpigotSave(this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || savePath.toString().endsWith("_nether") || savePath.toString().endsWith("_the_end") || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new SpigotSave(this.server, savePath.toAbsolutePath());
    }

    @Override
    public void saveAll() {
        this.plugin.runTask(() -> {
            for (World world : this.server.getWorlds()) {
                world.save();
            }
            this.server.savePlayers();
        });
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        Collection players = this.server.getOnlinePlayers();
        for (Player serverPlayer : players) {
            SpigotPlayer player = new SpigotPlayer(this.plugin, serverPlayer);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        OfflinePlayer[] players;
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        for (OfflinePlayer offlinePlayer : players = this.server.getOfflinePlayers()) {
            if (offlinePlayer.isOnline()) {
                Player serverPlayer = offlinePlayer.getPlayer();
                if (serverPlayer == null) continue;
                list.add(new SpigotPlayer(this.plugin, serverPlayer));
                continue;
            }
            list.add(new SpigotOfflinePlayer(this.plugin, this.server, offlinePlayer));
        }
        return list;
    }

    @Override
    public int getMaxPlayerCount() {
        return this.server.getMaxPlayers();
    }

    @Override
    public OPanelPlayer getPlayer(String uuid) {
        for (OPanelPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Override
    public void removePlayerData(String uuid) throws IOException {
        Path playerDataFolder = ((World)this.server.getWorlds().getFirst()).getWorldFolder().toPath().resolve("playerdata");
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat"));
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat_old"));
    }

    @Override
    public List<String> getBannedIps() {
        return new ArrayList<String>(this.server.getIPBans());
    }

    @Override
    public void banIp(String ip2) throws UnknownHostException {
        if (this.server.getIPBans().contains(ip2)) {
            return;
        }
        this.server.banIP(InetAddress.getByName(ip2));
    }

    @Override
    public void pardonIp(String ip2) throws UnknownHostException {
        if (!this.server.getIPBans().contains(ip2)) {
            return;
        }
        this.server.unbanIP(InetAddress.getByName(ip2));
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.hasWhitelist();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.plugin.runTask(() -> this.server.setWhitelist(enabled));
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new SpigotWhitelist(this.plugin, this.server, this.server.getWhitelistedPlayers());
    }

    @Override
    public void sendServerCommand(String command) {
        this.plugin.runTask(() -> Bukkit.dispatchCommand((CommandSender)this.server.getConsoleSender(), (String)command));
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (HelpTopic topic : this.server.getHelpMap().getHelpTopics()) {
            commands.add(topic.getName().toLowerCase().replaceFirst("/", ""));
        }
        return commands;
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        World world = (World)this.server.getWorlds().getFirst();
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : world.getGameRules()) {
            GameRule rule = GameRule.getByName((String)key);
            if (rule == null) continue;
            gamerules.put(key, world.getGameRuleValue(rule));
        }
        return gamerules;
    }

    @Override
    public void setGamerules(HashMap<String, Object> gamerules) {
        HashMap<String, Object> currentGamerules = this.getGamerules();
        this.plugin.runTask(() -> {
            World world = (World)this.server.getWorlds().getFirst();
            gamerules.forEach((key, value) -> {
                if (value == null) {
                    return;
                }
                Object currentValue = currentGamerules.get(key);
                if (value.equals(currentValue)) {
                    return;
                }
                GameRule rule = GameRule.getByName((String)key);
                if (rule == null) {
                    return;
                }
                if (rule.getType().equals(Boolean.class)) {
                    world.setGameRule(rule, (Object)((Boolean)value));
                } else if (rule.getType().equals(Integer.class)) {
                    int n = ((Number)value).intValue();
                    world.setGameRule(rule, (Object)n);
                } else {
                    this.sendServerCommand("gamerule " + key + " " + String.valueOf(value));
                }
            });
        });
    }

    @Override
    public void reload() {
        this.plugin.runTask(() -> ((Server)this.server).reload());
    }

    @Override
    public void stop() {
        this.server.shutdown();
    }

    @Override
    public long getIngameTime() {
        return ((World)this.server.getWorlds().getFirst()).getTime();
    }
}

