/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.client;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import java.util.Set;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.jakarta.client.internal.JakartaWebSocketClientContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaWebSocketShutdownContainer
extends ContainerLifeCycle
implements ServletContainerInitializer,
ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketShutdownContainer.class);

    @Override
    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        JakartaWebSocketClientContainer.setShutdownContainer(this);
        ctx.addListener(this);
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextInitialized({}) {}", (Object)sce, (Object)this);
        }
        LifeCycle.start(this);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextDestroyed({}) {}", (Object)sce, (Object)this);
        }
        LifeCycle.stop(this);
        this.removeBeans();
        JakartaWebSocketClientContainer.setShutdownContainer(null);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s, size=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getState(), this.getBeans().size());
    }
}

