/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_1;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.ServerType;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.forge_1_20_1.ForgeOfflinePlayer;
import net.opanel.forge_1_20_1.ForgePlayer;
import net.opanel.forge_1_20_1.ForgeSave;
import net.opanel.forge_1_20_1.ForgeWhitelist;
import net.opanel.forge_1_20_1.Main;
import net.opanel.utils.Utils;

public class ForgeServer
implements OPanelServer {
    private final MinecraftServer server;
    private final DedicatedServer dedicatedServer;

    public ForgeServer(MinecraftServer server) {
        this.server = server;
        this.dedicatedServer = (DedicatedServer)server;
    }

    @Override
    public ServerType getServerType() {
        return ServerType.FORGE;
    }

    @Override
    public byte[] getFavicon() {
        byte[] serverIconPNG = OPanelServer.super.getFavicon();
        if (serverIconPNG != null) {
            return serverIconPNG;
        }
        ServerStatus status = this.server.m_129928_();
        if (status == null) {
            return null;
        }
        Optional faviconOptional = status.f_134903_();
        if (faviconOptional.isEmpty()) {
            return null;
        }
        ServerStatus.Favicon favicon = (ServerStatus.Favicon)faviconOptional.get();
        return favicon.f_271462_();
    }

    @Override
    public void setFavicon(byte[] iconBytes) throws IOException {
        OPanelServer.super.setFavicon(iconBytes);
        ServerStatus status = this.server.m_129928_();
        ServerStatus.Favicon favicon = new ServerStatus.Favicon(iconBytes);
        ServerStatus newStatus = new ServerStatus(status.f_134900_(), status.f_134901_(), status.f_134902_(), Optional.of(favicon), status.f_242955_(), status.forgeData());
        try {
            Field statusIconField = MinecraftServer.class.getDeclaredField("f_271173_");
            statusIconField.setAccessible(true);
            statusIconField.set(this.server, favicon);
            Field statusField = MinecraftServer.class.getDeclaredField("f_129757_");
            statusField.setAccessible(true);
            statusField.set(this.server, newStatus);
        }
        catch (Exception e) {
            Main.LOGGER.warn("Cannot reload server favicon.");
        }
    }

    @Override
    public String getMotd() {
        return this.server.m_129916_();
    }

    @Override
    public void setMotd(String motd) throws IOException {
        this.server.m_129989_(motd);
        String formatted = motd.replaceAll("\n", Matcher.quoteReplacement("\\n"));
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("motd=.+", Matcher.quoteReplacement("motd=" + formatted)));
    }

    @Override
    public String getVersion() {
        return this.server.m_7630_();
    }

    @Override
    public int getPort() {
        return this.server.m_7010_();
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                ForgeSave save = new ForgeSave(this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new ForgeSave(this.server, savePath.toAbsolutePath());
    }

    @Override
    public void saveAll() {
        this.server.m_195514_(true, true, true);
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        List players = this.server.m_6846_().m_11314_();
        for (ServerPlayer serverPlayer : players) {
            ForgePlayer player = new ForgePlayer(serverPlayer);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        Path playerDataPath = this.server.m_129843_(LevelResource.f_78176_);
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>(this.getOnlinePlayers());
        try (Stream<Path> stream = Files.list(playerDataPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0]) && item.toString().endsWith(".dat")).forEach(item -> {
                try {
                    String uuid = item.getFileName().toString().replace(".dat", "");
                    ServerPlayer serverPlayer = this.server.m_6846_().m_11259_(UUID.fromString(uuid));
                    if (serverPlayer != null && !serverPlayer.m_9232_()) {
                        return;
                    }
                    ForgeOfflinePlayer player = new ForgeOfflinePlayer(this.server, UUID.fromString(uuid));
                    list.add(player);
                }
                catch (Exception e) {
                    Main.LOGGER.warn("Cannot read the player data from " + String.valueOf(item.getFileName()) + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getMaxPlayerCount() {
        return this.server.m_7418_();
    }

    @Override
    public OPanelPlayer getPlayer(String uuid) {
        for (OPanelPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Override
    public void removePlayerData(String uuid) throws IOException {
        Path playerDataFolder = this.server.m_129843_(LevelResource.f_78176_);
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat"));
        Files.deleteIfExists(playerDataFolder.resolve(uuid + ".dat_old"));
    }

    @Override
    public List<String> getBannedIps() {
        Collection entries = this.server.m_6846_().m_11299_().m_11395_();
        ArrayList<String> list = new ArrayList<String>();
        entries.forEach(entry -> list.add(entry.m_8003_().getString()));
        return list;
    }

    @Override
    public void banIp(String ip) {
        if (this.getBannedIps().contains(ip)) {
            return;
        }
        this.server.m_6846_().m_11299_().m_11381_((StoredUserEntry)new IpBanListEntry(ip));
    }

    @Override
    public void pardonIp(String ip) {
        if (!this.getBannedIps().contains(ip)) {
            return;
        }
        this.server.m_6846_().m_11299_().m_11393_((Object)ip);
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.m_6846_().m_11311_();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.server.m_6846_().m_6628_(enabled);
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new ForgeWhitelist(this.server.m_6846_().m_11305_());
    }

    @Override
    public void sendServerCommand(String command) {
        Commands manager = this.server.m_129892_();
        CommandSourceStack source = this.server.m_129893_();
        manager.m_230957_(source, command);
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        CommandDispatcher dispatcher = this.server.m_129892_().m_82094_();
        for (CommandNode node : dispatcher.getRoot().getChildren()) {
            commands.add(node.getName());
        }
        return commands;
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        CompoundTag gamerulesNbt = this.server.m_129900_().m_46163_();
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : gamerulesNbt.m_128431_()) {
            String valueStr = gamerulesNbt.m_128461_(key);
            if (valueStr.equals("true") || valueStr.equals("false")) {
                gamerules.put(key, Boolean.valueOf(valueStr));
                continue;
            }
            if (Utils.isNumeric(valueStr)) {
                gamerules.put(key, Integer.valueOf(valueStr));
                continue;
            }
            gamerules.put(key, valueStr);
        }
        return gamerules;
    }

    @Override
    public void setGamerules(final HashMap<String, Object> gamerules) {
        final HashMap<String, Object> currentGamerules = this.getGamerules();
        final GameRules gameRulesObj = this.server.m_129900_();
        GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> key, GameRules.Type<T> type) {
                super.m_6889_(key, type);
                String ruleName = key.m_46328_();
                Object value = gamerules.get(ruleName);
                if (value == null) {
                    return;
                }
                Object currentValue = currentGamerules.get(ruleName);
                if (value.equals(currentValue)) {
                    return;
                }
                GameRules.Value rule = type.m_46352_();
                if (rule instanceof GameRules.BooleanValue) {
                    ((GameRules.BooleanValue)rule).m_46246_(((Boolean)value).booleanValue(), ForgeServer.this.server);
                    gameRulesObj.m_46170_(key).m_5614_(rule, ForgeServer.this.server);
                } else if (rule instanceof GameRules.IntegerValue) {
                    int n = ((Number)value).intValue();
                    ((GameRules.IntegerValue)rule).m_151489_(n, ForgeServer.this.server);
                    gameRulesObj.m_46170_(key).m_5614_(rule, ForgeServer.this.server);
                } else {
                    ForgeServer.this.sendServerCommand("gamerule " + ruleName + " " + String.valueOf(value));
                }
            }
        });
    }

    @Override
    public void reload() {
        this.sendServerCommand("reload");
    }

    @Override
    public void stop() {
        this.server.m_7570_(false);
    }

    @Override
    public long getIngameTime() {
        return this.server.m_129783_().m_46468_();
    }
}

