/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_20_1;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;

public class ForgeOfflinePlayer
implements OPanelPlayer {
    private final PlayerList playerManager;
    private final Path playerDataPath;
    private final GameProfile profile;
    private final UUID uuid;

    public ForgeOfflinePlayer(MinecraftServer server, UUID uuid) {
        this.playerManager = server.m_6846_();
        this.playerDataPath = server.m_129843_(LevelResource.f_78176_).resolve(String.valueOf(uuid) + ".dat");
        GameProfileCache profileCache = server.m_129927_();
        this.uuid = uuid;
        if (!Files.exists(this.playerDataPath, new LinkOption[0])) {
            throw new NullPointerException("Player data file for UUID " + String.valueOf(uuid) + " unavailable.");
        }
        if (profileCache == null) {
            throw new NullPointerException("Cannot get player profile cache.");
        }
        ServerPlayer serverPlayer = this.playerManager.m_11259_(uuid);
        if (serverPlayer != null && !serverPlayer.m_9232_()) {
            throw new IllegalStateException("The provided player is online, please use ForgePlayer class instead.");
        }
        Optional profileOpt = profileCache.m_11002_(uuid);
        if (profileOpt.isEmpty()) {
            throw new NullPointerException("Cannot get the game profile of the provided player.");
        }
        this.profile = (GameProfile)profileOpt.get();
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public boolean isOp() {
        return this.playerManager.m_11303_(this.profile);
    }

    @Override
    public boolean isBanned() {
        return this.playerManager.m_11295_().m_11406_(this.profile);
    }

    @Override
    public OPanelGameMode getGameMode() {
        try {
            CompoundTag nbt = NbtIo.m_128937_((File)this.playerDataPath.toFile());
            int gamemodeId = nbt.m_128451_("playerGameType");
            GameType gamemode = GameType.m_46393_((int)gamemodeId);
            switch (gamemode) {
                case ADVENTURE: {
                    return OPanelGameMode.ADVENTURE;
                }
                case SURVIVAL: {
                    return OPanelGameMode.SURVIVAL;
                }
                case CREATIVE: {
                    return OPanelGameMode.CREATIVE;
                }
                case SPECTATOR: {
                    return OPanelGameMode.SPECTATOR;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        try {
            CompoundTag nbt = NbtIo.m_128937_((File)this.playerDataPath.toFile());
            switch (gamemode) {
                case ADVENTURE: {
                    nbt.m_128405_("playerGameType", 2);
                    break;
                }
                case SURVIVAL: {
                    nbt.m_128405_("playerGameType", 0);
                    break;
                }
                case CREATIVE: {
                    nbt.m_128405_("playerGameType", 1);
                    break;
                }
                case SPECTATOR: {
                    nbt.m_128405_("playerGameType", 3);
                }
            }
            NbtIo.m_128944_((CompoundTag)nbt, (File)this.playerDataPath.toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.playerManager.m_5749_(this.profile);
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.playerManager.m_5750_(this.profile);
    }

    @Override
    public void kick(String reason) {
        throw new IllegalStateException("The player is offline.");
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        UserBanList bannedList = this.playerManager.m_11295_();
        UserBanListEntry entry = new UserBanListEntry(this.profile, new Date(), null, null, reason);
        bannedList.m_11381_((StoredUserEntry)entry);
    }

    @Override
    public String getBanReason() {
        if (!this.isBanned()) {
            return null;
        }
        UserBanListEntry banEntry = (UserBanListEntry)this.playerManager.m_11295_().m_11388_((Object)this.profile);
        if (banEntry == null) {
            return null;
        }
        return banEntry.m_10962_();
    }

    @Override
    public void pardon() {
        if (!this.isBanned()) {
            return;
        }
        this.playerManager.m_11295_().m_11393_((Object)this.profile);
    }

    @Override
    public int getPing() {
        throw new IllegalStateException("The player is offline.");
    }
}

