/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.features.CodeOfConductFeature;
import net.opanel.utils.Utils;
import net.opanel.web.BaseServlet;

public class ControlServlet
extends BaseServlet {
    public static final String route = "/api/control/*";

    public ControlServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (reqPath == null || reqPath.equals("/")) {
            this.sendResponse(res, 400);
            return;
        }
        switch (reqPath.substring(1)) {
            case "properties": {
                try {
                    obj.put("properties", Utils.stringToBase64(OPanelServer.getPropertiesContent()));
                    this.sendResponse(res, obj);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendResponse(res, 500);
                }
                break;
            }
            case "code-of-conduct": {
                if (!(server instanceof CodeOfConductFeature)) {
                    this.sendResponse(res, 503);
                    return;
                }
                try {
                    HashMap<String, String> codeOfConducts = ((CodeOfConductFeature)((Object)server)).getCodeOfConducts();
                    codeOfConducts.replaceAll((lang, content) -> Utils.stringToBase64(content));
                    obj.put("codeOfConducts", codeOfConducts);
                    this.sendResponse(res, obj);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendResponse(res, 500);
                }
                break;
            }
            default: {
                this.sendResponse(res, 400);
            }
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath == null || reqPath.equals("/")) {
            this.sendResponse(res, 400);
            return;
        }
        switch (reqPath.substring(1)) {
            case "stop": {
                server.stop();
                break;
            }
            case "reload": {
                server.reload();
                break;
            }
            case "properties": {
                try {
                    String properties = this.getRequestBody(req, String.class);
                    if (properties == null || properties.isEmpty()) {
                        this.sendResponse(res, 400);
                        return;
                    }
                    OPanelServer.writePropertiesContent(Utils.base64ToString(properties));
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendResponse(res, 500, e.getMessage());
                    return;
                }
            }
            case "world": {
                String saveName = req.getParameter("save");
                if (saveName == null) {
                    this.sendResponse(res, 400);
                    return;
                }
                OPanelSave save = server.getSave(saveName);
                if (save == null) {
                    this.sendResponse(res, 404);
                    return;
                }
                try {
                    save.setToCurrent();
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendResponse(res, 500);
                    return;
                }
            }
            case "code-of-conduct": {
                if (!(server instanceof CodeOfConductFeature)) {
                    this.sendResponse(res, 503);
                    return;
                }
                try {
                    String lang = req.getParameter("lang");
                    String content = this.getRequestBody(req, String.class);
                    if (lang == null) {
                        this.sendResponse(res, 400);
                        return;
                    }
                    ((CodeOfConductFeature)((Object)server)).updateOrCreateCodeOfConduct(lang, content != null && !content.isEmpty() ? Utils.base64ToString(content) : "");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendResponse(res, 500, e.getMessage());
                }
                break;
            }
            default: {
                this.sendResponse(res, 400);
                return;
            }
        }
        this.sendResponse(res, 200);
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        String reqPath = req.getPathInfo();
        OPanelServer server = this.plugin.getServer();
        if (reqPath == null || reqPath.equals("/")) {
            this.sendResponse(res, 400);
            return;
        }
        switch (reqPath.substring(1)) {
            case "code-of-conduct": {
                if (!(server instanceof CodeOfConductFeature)) {
                    this.sendResponse(res, 503);
                    return;
                }
                try {
                    String lang = req.getParameter("lang");
                    if (lang == null) {
                        this.sendResponse(res, 400);
                        return;
                    }
                    ((CodeOfConductFeature)((Object)server)).removeCodeOfConduct(lang);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendResponse(res, 500, e.getMessage());
                }
                break;
            }
            default: {
                this.sendResponse(res, 400);
                return;
            }
        }
        this.sendResponse(res, 200);
    }
}

