/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.spigot_1_19_4;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.deps.nbtapi.NBT;
import net.opanel.deps.nbtapi.handler.NBTHandlers;
import net.opanel.deps.nbtapi.iface.ReadWriteNBT;
import net.opanel.utils.Utils;
import org.bukkit.Server;
import org.bukkit.World;

public class SpigotSave
implements OPanelSave {
    private final Server server;
    private final Path savePath;
    private ReadWriteNBT nbt;

    public SpigotSave(Server server, Path path) {
        this.server = server;
        this.savePath = path;
        try {
            this.nbt = NBT.readFile(this.savePath.resolve("level.dat").toFile()).getCompound("Data");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveNbt() throws IOException {
        ReadWriteNBT dataNbt = NBT.createNBTObject();
        dataNbt.set("Data", this.nbt, NBTHandlers.STORE_READWRITE_TAG);
        NBT.writeFile(this.savePath.resolve("level.dat").toFile(), dataNbt);
    }

    @Override
    public String getName() {
        return this.savePath.getFileName().toString();
    }

    @Override
    public String getDisplayName() {
        return this.nbt.getString("LevelName").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.setString("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public Path getPath() {
        return this.savePath.toAbsolutePath();
    }

    @Override
    public long getSize() throws IOException {
        return Utils.getDirectorySize(this.savePath);
    }

    @Override
    public boolean isRunning() {
        return ((World)this.server.getWorlds().get(0)).getName().equals(this.getName());
    }

    @Override
    public boolean isCurrent() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(OPanelServer.serverPropertiesPath.toFile()));
        return properties.getProperty("level-name").replaceAll("\u00c2", "").equals(this.getName());
    }

    @Override
    public void setToCurrent() throws IOException {
        if (this.isCurrent()) {
            return;
        }
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("level-name=.+", "level-name=" + this.getName()));
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        int gamemode = this.nbt.getInteger("GameType");
        switch (gamemode) {
            case 2: {
                return OPanelGameMode.ADVENTURE;
            }
            case 0: {
                return OPanelGameMode.SURVIVAL;
            }
            case 1: {
                return OPanelGameMode.CREATIVE;
            }
            case 3: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        switch (gamemode) {
            case ADVENTURE: {
                this.nbt.setInteger("GameType", 2);
                break;
            }
            case SURVIVAL: {
                this.nbt.setInteger("GameType", 0);
                break;
            }
            case CREATIVE: {
                this.nbt.setInteger("GameType", 1);
                break;
            }
            case SPECTATOR: {
                this.nbt.setInteger("GameType", 3);
            }
        }
        this.saveNbt();
    }

    @Override
    public void delete() throws IOException {
        Utils.deleteDirectoryRecursively(this.savePath);
    }
}

