/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.spigot_1_21;

import java.util.Date;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelPlayer;
import net.opanel.spigot_1_21.Main;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class SpigotPlayer
implements OPanelPlayer {
    private final Main plugin;
    private final Player player;

    public SpigotPlayer(Main plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public String getUUID() {
        return this.player.getUniqueId().toString();
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean isOp() {
        return this.player.isOp();
    }

    @Override
    public boolean isBanned() {
        return false;
    }

    @Override
    public OPanelGameMode getGameMode() {
        GameMode gamemode = this.player.getGameMode();
        switch (gamemode) {
            case ADVENTURE: {
                return OPanelGameMode.ADVENTURE;
            }
            case SURVIVAL: {
                return OPanelGameMode.SURVIVAL;
            }
            case CREATIVE: {
                return OPanelGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setGameMode(OPanelGameMode gamemode) {
        this.plugin.runTask(() -> {
            switch (gamemode) {
                case ADVENTURE: {
                    this.player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case SURVIVAL: {
                    this.player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case CREATIVE: {
                    this.player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case SPECTATOR: {
                    this.player.setGameMode(GameMode.SPECTATOR);
                }
            }
        });
    }

    @Override
    public void giveOp() {
        if (this.isOp()) {
            return;
        }
        this.plugin.runTask(() -> this.player.setOp(true));
    }

    @Override
    public void depriveOp() {
        if (!this.isOp()) {
            return;
        }
        this.plugin.runTask(() -> this.player.setOp(false));
    }

    @Override
    public void kick(String reason) {
        this.plugin.runTask(() -> this.player.kickPlayer(reason));
    }

    @Override
    public void ban(String reason) {
        if (this.isBanned()) {
            return;
        }
        this.plugin.runTask(() -> this.player.ban(reason, (Date)null, null, true));
    }

    @Override
    public String getBanReason() {
        return null;
    }

    @Override
    public void pardon() {
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }
}

