/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.forge_1_21_8;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelResource;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;

public class ForgeSave
implements OPanelSave {
    private final MinecraftServer server;
    private final Path savePath;
    private CompoundTag nbt;

    public ForgeSave(MinecraftServer server, Path path) {
        this.server = server;
        this.savePath = path;
        try {
            Optional optionalNbt = NbtIo.readCompressed((Path)this.savePath.resolve("level.dat"), (NbtAccounter)NbtAccounter.create((long)0x200000L)).get("Data").asCompound();
            if (optionalNbt.isEmpty()) {
                throw new IOException("Cannot find a valid level.dat");
            }
            this.nbt = (CompoundTag)optionalNbt.get();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveNbt() throws IOException {
        CompoundTag dataNbt = new CompoundTag();
        dataNbt.put("Data", (Tag)this.nbt);
        NbtIo.writeCompressed((CompoundTag)dataNbt, (Path)this.savePath.resolve("level.dat"));
    }

    @Override
    public String getName() {
        return this.savePath.getFileName().toString();
    }

    @Override
    public String getDisplayName() {
        return this.nbt.getStringOr("LevelName", "world").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.putString("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public Path getPath() {
        return this.savePath.toAbsolutePath();
    }

    @Override
    public long getSize() throws IOException {
        return Utils.getDirectorySize(this.savePath);
    }

    @Override
    public boolean isRunning() {
        return this.server.getWorldPath(LevelResource.LEVEL_DATA_FILE).getParent().getFileName().toString().equals(this.getName());
    }

    @Override
    public boolean isCurrent() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(OPanelServer.serverPropertiesPath.toFile()));
        return properties.getProperty("level-name").replaceAll("\u00c2", "").equals(this.getName());
    }

    @Override
    public void setToCurrent() throws IOException {
        if (this.isCurrent()) {
            return;
        }
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("level-name=.+", "level-name=" + this.getName()));
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        GameType gamemode = GameType.byId((int)this.nbt.getIntOr("GameType", 0));
        switch (gamemode) {
            case ADVENTURE: {
                return OPanelGameMode.ADVENTURE;
            }
            case SURVIVAL: {
                return OPanelGameMode.SURVIVAL;
            }
            case CREATIVE: {
                return OPanelGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        switch (gamemode) {
            case ADVENTURE: {
                this.nbt.putInt("GameType", 2);
                break;
            }
            case SURVIVAL: {
                this.nbt.putInt("GameType", 0);
                break;
            }
            case CREATIVE: {
                this.nbt.putInt("GameType", 1);
                break;
            }
            case SPECTATOR: {
                this.nbt.putInt("GameType", 3);
            }
        }
        this.saveNbt();
    }

    @Override
    public void delete() throws IOException {
        Utils.deleteDirectoryRecursively(this.savePath);
    }
}

