/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.folia_1_20;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.opanel.ServerType;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.folia_1_20.FoliaOfflinePlayer;
import net.opanel.folia_1_20.FoliaPlayer;
import net.opanel.folia_1_20.FoliaSave;
import net.opanel.folia_1_20.FoliaWhitelist;
import net.opanel.folia_1_20.Main;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;

public class FoliaServer
implements OPanelServer {
    private static final Path serverIconPath = Paths.get("", new String[0]).resolve("server-icon.png");
    private final Main plugin;
    private final Server server;

    public FoliaServer(Main plugin, Server server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Override
    public ServerType getServerType() {
        return ServerType.FOLIA;
    }

    @Override
    public byte[] getFavicon() {
        if (!Files.exists(serverIconPath, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readAllBytes(serverIconPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public void setMotd(String motd) throws IOException {
        this.server.setMotd(motd);
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("motd=.+", "motd=" + motd));
    }

    @Override
    public String getVersion() {
        return this.server.getBukkitVersion();
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> !path.toString().endsWith("_nether") && !path.toString().endsWith("_the_end") && Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                FoliaSave save = new FoliaSave(this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || savePath.toString().endsWith("_nether") || savePath.toString().endsWith("_the_end") || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new FoliaSave(this.server, savePath.toAbsolutePath());
    }

    @Override
    public void saveAll() {
        this.plugin.runTask(() -> {
            for (World world : this.server.getWorlds()) {
                world.save();
            }
            this.server.savePlayers();
        });
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        Collection players = this.server.getOnlinePlayers();
        for (Player serverPlayer : players) {
            FoliaPlayer player = new FoliaPlayer(this.plugin, serverPlayer);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        OfflinePlayer[] players;
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        for (OfflinePlayer offlinePlayer : players = this.server.getOfflinePlayers()) {
            if (offlinePlayer.isOnline()) {
                Player serverPlayer = offlinePlayer.getPlayer();
                if (serverPlayer == null) continue;
                list.add(new FoliaPlayer(this.plugin, serverPlayer));
                continue;
            }
            list.add(new FoliaOfflinePlayer(this.plugin, this.server, offlinePlayer));
        }
        return list;
    }

    @Override
    public int getMaxPlayerCount() {
        return this.server.getMaxPlayers();
    }

    @Override
    public OPanelPlayer getPlayer(String uuid) {
        for (OPanelPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.hasWhitelist();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.plugin.runTask(() -> this.server.setWhitelist(enabled));
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new FoliaWhitelist(this.plugin, this.server, this.server.getWhitelistedPlayers());
    }

    @Override
    public void sendServerCommand(String command) {
        this.plugin.runTask(() -> Bukkit.dispatchCommand((CommandSender)this.server.getConsoleSender(), (String)command));
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (HelpTopic topic : this.server.getHelpMap().getHelpTopics()) {
            commands.add(topic.getName().toLowerCase().replaceFirst("/", ""));
        }
        return commands;
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        World world = (World)this.server.getWorlds().getFirst();
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : world.getGameRules()) {
            GameRule rule = GameRule.getByName((String)key);
            if (rule == null) continue;
            gamerules.put(key, world.getGameRuleValue(rule));
        }
        return gamerules;
    }

    @Override
    public void setGamerules(HashMap<String, Object> gamerules) {
        this.plugin.runTask(() -> {
            World world = (World)this.server.getWorlds().getFirst();
            gamerules.forEach((key, value) -> {
                if (value == null) {
                    return;
                }
                GameRule rule = GameRule.getByName((String)key);
                if (rule == null) {
                    return;
                }
                if (value instanceof Boolean) {
                    world.setGameRule(rule, (Object)((Boolean)value));
                } else if (value instanceof Number) {
                    world.setGameRule(rule, (Object)Double.valueOf((Double)value).intValue());
                } else if (value instanceof String) {
                    world.setGameRule(rule, (Object)((String)value));
                }
            });
        });
    }

    @Override
    public void reload() {
        this.sendServerCommand("reload confirm");
    }

    @Override
    public void stop() {
        this.server.shutdown();
    }

    @Override
    public long getIngameTime() {
        return ((World)this.server.getWorlds().getFirst()).getTime();
    }
}

