/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_21_5;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2926;
import net.minecraft.class_2994;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.opanel.ServerType;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.common.OPanelWhitelist;
import net.opanel.fabric_1_21_5.FabricOfflinePlayer;
import net.opanel.fabric_1_21_5.FabricPlayer;
import net.opanel.fabric_1_21_5.FabricSave;
import net.opanel.fabric_1_21_5.FabricWhitelist;
import net.opanel.fabric_1_21_5.Main;
import net.opanel.utils.Utils;

public class FabricServer
implements OPanelServer {
    private final MinecraftServer server;
    private final class_2994 dedicatedServer;

    public FabricServer(MinecraftServer server) {
        this.server = server;
        this.dedicatedServer = (class_2994)server;
    }

    @Override
    public ServerType getServerType() {
        return ServerType.FABRIC;
    }

    @Override
    public byte[] getFavicon() {
        class_2926 metadata = this.server.method_3765();
        if (metadata == null) {
            return null;
        }
        Optional faviconOptional = metadata.comp_1276();
        if (faviconOptional.isEmpty()) {
            return null;
        }
        class_2926.class_8145 favicon = (class_2926.class_8145)faviconOptional.get();
        return favicon.comp_1278();
    }

    @Override
    public String getMotd() {
        return this.server.method_3818();
    }

    @Override
    public void setMotd(String motd) throws IOException {
        this.server.method_3834(motd);
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("motd=.+", "motd=" + motd));
    }

    @Override
    public String getVersion() {
        return this.server.method_3827();
    }

    @Override
    public int getPort() {
        return this.server.method_3756();
    }

    @Override
    public List<OPanelSave> getSaves() {
        ArrayList<OPanelSave> list = new ArrayList<OPanelSave>();
        try (Stream<Path> stream = Files.list(Paths.get("", new String[0]));){
            stream.filter(path -> Files.exists(path.resolve("level.dat"), new LinkOption[0]) && !Files.isDirectory(path.resolve("level.dat"), new LinkOption[0])).map(Path::toAbsolutePath).forEach(path -> {
                FabricSave save = new FabricSave(this.server, (Path)path);
                list.add(save);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public OPanelSave getSave(String saveName) {
        Path savePath = Paths.get("", new String[0]).resolve(saveName);
        if (!Files.exists(savePath, new LinkOption[0]) || !Files.exists(savePath.resolve("level.dat"), new LinkOption[0])) {
            return null;
        }
        return new FabricSave(this.server, savePath.toAbsolutePath());
    }

    @Override
    public void saveAll() {
        this.server.method_39218(true, true, true);
    }

    @Override
    public List<OPanelPlayer> getOnlinePlayers() {
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>();
        List players = this.server.method_3760().method_14571();
        for (class_3222 serverPlayer : players) {
            FabricPlayer player = new FabricPlayer(serverPlayer);
            list.add(player);
        }
        return list;
    }

    @Override
    public List<OPanelPlayer> getPlayers() {
        Path playerDataPath = this.server.method_27050(class_5218.field_24182);
        ArrayList<OPanelPlayer> list = new ArrayList<OPanelPlayer>(this.getOnlinePlayers());
        try (Stream<Path> stream = Files.list(playerDataPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0]) && item.toString().endsWith(".dat")).forEach(item -> {
                try {
                    String uuid = item.getFileName().toString().replace(".dat", "");
                    class_3222 serverPlayer = this.server.method_3760().method_14602(UUID.fromString(uuid));
                    if (serverPlayer != null && !serverPlayer.method_14239()) {
                        return;
                    }
                    FabricOfflinePlayer player = new FabricOfflinePlayer(this.server, UUID.fromString(uuid));
                    list.add(player);
                }
                catch (Exception e) {
                    Main.LOGGER.warn("Cannot read the player data from " + String.valueOf(item.getFileName()) + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getMaxPlayerCount() {
        return this.server.method_3802();
    }

    @Override
    public OPanelPlayer getPlayer(String uuid) {
        for (OPanelPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.server.method_3760().method_14614();
    }

    @Override
    public void setWhitelistEnabled(boolean enabled) {
        this.server.method_3760().method_14557(enabled);
    }

    @Override
    public OPanelWhitelist getWhitelist() {
        return new FabricWhitelist(this.server.method_3760().method_14590());
    }

    @Override
    public void sendServerCommand(String command) {
        class_2170 manager = this.server.method_3734();
        class_2168 source = this.server.method_3739();
        manager.method_44252(source, command);
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        CommandDispatcher dispatcher = this.server.method_3734().method_9235();
        for (CommandNode node : dispatcher.getRoot().getChildren()) {
            commands.add(node.getName());
        }
        return commands;
    }

    @Override
    public HashMap<String, Object> getGamerules() {
        class_2487 gamerulesNbt = this.server.method_3767().method_8358();
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (String key : gamerulesNbt.method_10541()) {
            String valueStr = gamerulesNbt.method_68564(key, "");
            if (valueStr.equals("true") || valueStr.equals("false")) {
                gamerules.put(key, Boolean.valueOf(valueStr));
                continue;
            }
            if (Utils.isNumeric(valueStr)) {
                gamerules.put(key, Integer.valueOf(valueStr));
                continue;
            }
            gamerules.put(key, valueStr);
        }
        return gamerules;
    }

    @Override
    public void setGamerules(final HashMap<String, Object> gamerules) {
        final class_1928 gameRulesObj = this.server.method_3767();
        gameRulesObj.method_20744(new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                super.method_20762(key, type);
                gamerules.forEach((ruleName, value) -> {
                    if (value == null) {
                        return;
                    }
                    if (key.method_20771().equals(ruleName)) {
                        if (value instanceof Boolean) {
                            gameRulesObj.method_20746(key).method_27337((class_1928.class_4315)new class_1928.class_4310(type, ((Boolean)value).booleanValue()), FabricServer.this.server);
                        } else if (value instanceof Number) {
                            gameRulesObj.method_20746(key).method_27337((class_1928.class_4315)new class_1928.class_4312(type, Double.valueOf((Double)value).intValue()), FabricServer.this.server);
                        } else if (value instanceof String) {
                            FabricServer.this.sendServerCommand("gamerule " + ruleName + " " + String.valueOf(value));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void reload() {
        this.sendServerCommand("reload");
    }

    @Override
    public void stop() {
        this.server.method_3747(false);
    }

    @Override
    public long getIngameTime() {
        return this.server.method_30002().method_8532();
    }
}

