/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.deps.oshi.hardware.platform.unix.freebsd;

import java.util.List;
import net.opanel.deps.oshi.annotation.concurrent.ThreadSafe;
import net.opanel.deps.oshi.hardware.CentralProcessor;
import net.opanel.deps.oshi.hardware.ComputerSystem;
import net.opanel.deps.oshi.hardware.Display;
import net.opanel.deps.oshi.hardware.GlobalMemory;
import net.opanel.deps.oshi.hardware.GraphicsCard;
import net.opanel.deps.oshi.hardware.HWDiskStore;
import net.opanel.deps.oshi.hardware.NetworkIF;
import net.opanel.deps.oshi.hardware.PowerSource;
import net.opanel.deps.oshi.hardware.Sensors;
import net.opanel.deps.oshi.hardware.SoundCard;
import net.opanel.deps.oshi.hardware.UsbDevice;
import net.opanel.deps.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import net.opanel.deps.oshi.hardware.platform.unix.BsdNetworkIF;
import net.opanel.deps.oshi.hardware.platform.unix.UnixDisplay;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdCentralProcessor;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdComputerSystem;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdGlobalMemory;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdGraphicsCard;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdHWDiskStore;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdPowerSource;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdSensors;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdSoundCard;
import net.opanel.deps.oshi.hardware.platform.unix.freebsd.FreeBsdUsbDevice;

@ThreadSafe
public final class FreeBsdHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public ComputerSystem createComputerSystem() {
        return new FreeBsdComputerSystem();
    }

    @Override
    public GlobalMemory createMemory() {
        return new FreeBsdGlobalMemory();
    }

    @Override
    public CentralProcessor createProcessor() {
        return new FreeBsdCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new FreeBsdSensors();
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return FreeBsdPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return FreeBsdHWDiskStore.getDisks();
    }

    @Override
    public List<Display> getDisplays() {
        return UnixDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return BsdNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return FreeBsdUsbDevice.getUsbDevices(tree);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return FreeBsdSoundCard.getSoundCards();
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return FreeBsdGraphicsCard.getGraphicsCards();
    }
}

