/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.io.FilteredOutputStream;
import io.jsonwebtoken.io.EncodingException;
import io.jsonwebtoken.lang.Assert;
import java.io.OutputStream;

public class EncodingOutputStream
extends FilteredOutputStream {
    private final String codecName;
    private final String name;

    public EncodingOutputStream(OutputStream out, String codecName, String name) {
        super(out);
        this.codecName = Assert.hasText(codecName, "codecName cannot be null or empty.");
        this.name = Assert.hasText(name, "name cannot be null or empty.");
    }

    @Override
    protected void onThrowable(Throwable t) {
        String msg = "Unable to " + this.codecName + "-encode " + this.name + ": " + t.getMessage();
        throw new EncodingException(msg, t);
    }
}

