/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.logger;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.opanel.utils.Utils;

public abstract class Loggable {
    private static final Path logFolderPath = Paths.get("", new String[0]).resolve("logs");

    public abstract void info(String var1);

    public abstract void warn(String var1);

    public abstract void error(String var1);

    public List<String> getLogFileList() throws IOException {
        if (!Files.exists(logFolderPath, new LinkOption[0])) {
            Files.createDirectory(logFolderPath, new FileAttribute[0]);
        }
        if (!Files.isDirectory(logFolderPath, new LinkOption[0])) {
            throw new IOException("Cannot find the logs folder, but found a logs file.");
        }
        ArrayList<String> fileList = new ArrayList<String>();
        try (Stream<Path> stream = Files.list(logFolderPath);){
            stream.filter(item -> !Files.isDirectory(item, new LinkOption[0])).map(Path::getFileName).forEach(name -> fileList.add(name.toString()));
        }
        return fileList;
    }

    public String getLogContent(String fileName) throws IOException {
        Path filePath = Paths.get(logFolderPath.toString(), fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new IOException("Cannot find the specified log file.");
        }
        if (filePath.toString().endsWith(".log") || filePath.toString().endsWith("txt")) {
            return Utils.readTextFile(filePath);
        }
        if (filePath.toString().endsWith(".gz")) {
            return Utils.decompressTextGzip(filePath);
        }
        throw new IOException("Unexpected file extension.");
    }

    public void deleteLog(String fileName) throws IOException {
        Path filePath = Paths.get(logFolderPath.toString(), fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new IOException("Cannot find the specified log file.");
        }
        Files.delete(filePath);
    }
}

