/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.fabric_1_19;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.opanel.common.OPanelGameMode;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelServer;
import net.opanel.utils.Utils;

public class FabricSave
implements OPanelSave {
    private final MinecraftServer server;
    private final Path savePath;
    private class_2487 nbt;

    public FabricSave(MinecraftServer server, Path path) {
        this.server = server;
        this.savePath = path;
        try {
            this.nbt = class_2507.method_30613((File)this.savePath.resolve("level.dat").toFile()).method_10562("Data");
            if (this.nbt.method_33133()) {
                throw new IOException("Cannot find a valid level.dat");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveNbt() throws IOException {
        class_2487 dataNbt = new class_2487();
        dataNbt.method_10566("Data", (class_2520)this.nbt);
        class_2507.method_30614((class_2487)dataNbt, (File)this.savePath.resolve("level.dat").toFile());
    }

    @Override
    public String getName() {
        return this.savePath.getFileName().toString();
    }

    @Override
    public String getDisplayName() {
        return this.nbt.method_10558("LevelName").replaceAll("\u00c2", "");
    }

    @Override
    public void setDisplayName(String displayName) throws IOException {
        this.nbt.method_10582("LevelName", displayName);
        this.saveNbt();
    }

    @Override
    public Path getPath() {
        return this.savePath.toAbsolutePath();
    }

    @Override
    public long getSize() throws IOException {
        return Utils.getDirectorySize(this.savePath);
    }

    @Override
    public boolean isRunning() {
        return this.server.method_27050(class_5218.field_24184).getParent().getFileName().toString().equals(this.getName());
    }

    @Override
    public boolean isCurrent() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(OPanelServer.serverPropertiesPath.toFile()));
        return properties.getProperty("level-name").replaceAll("\u00c2", "").equals(this.getName());
    }

    @Override
    public void setToCurrent() throws IOException {
        if (this.isCurrent()) {
            return;
        }
        OPanelServer.writePropertiesContent(OPanelServer.getPropertiesContent().replaceAll("level-name=.+", "level-name=" + this.getName()));
    }

    @Override
    public OPanelGameMode getDefaultGameMode() {
        class_1934 gamemode = class_1934.method_8384((int)this.nbt.method_10550("GameType"));
        switch (gamemode) {
            case field_9216: {
                return OPanelGameMode.ADVENTURE;
            }
            case field_9215: {
                return OPanelGameMode.SURVIVAL;
            }
            case field_9220: {
                return OPanelGameMode.CREATIVE;
            }
            case field_9219: {
                return OPanelGameMode.SPECTATOR;
            }
        }
        return null;
    }

    @Override
    public void setDefaultGameMode(OPanelGameMode gamemode) throws IOException {
        switch (gamemode) {
            case ADVENTURE: {
                this.nbt.method_10569("GameType", 2);
                break;
            }
            case SURVIVAL: {
                this.nbt.method_10569("GameType", 0);
                break;
            }
            case CREATIVE: {
                this.nbt.method_10569("GameType", 1);
                break;
            }
            case SPECTATOR: {
                this.nbt.method_10569("GameType", 3);
            }
        }
        this.saveNbt();
    }

    @Override
    public void delete() throws IOException {
        Utils.deleteDirectoryRecursively(this.savePath);
    }
}

