/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.common.OPanelServer;
import net.opanel.web.BaseServlet;

public class GamerulesServlet
extends BaseServlet {
    public static final String route = "/api/gamerules";

    public GamerulesServlet(OPanel plugin) {
        super(plugin);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        OPanelServer server = this.plugin.getServer();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("gamerules", server.getGamerules());
        this.sendResponse(res, obj);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.authCookie(req)) {
            this.sendResponse(res, 401);
            return;
        }
        GamerulesEditRequestBodyType reqBody = this.getRequestBody(req, GamerulesEditRequestBodyType.class);
        if (reqBody.gamerules == null) {
            this.sendResponse(res, 400);
            return;
        }
        this.plugin.getServer().setGamerules(reqBody.gamerules);
        this.sendResponse(res, 200);
    }

    private static class GamerulesEditRequestBodyType {
        HashMap<String, Object> gamerules;

        private GamerulesEditRequestBodyType() {
        }
    }
}

