/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.web;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.opanel.OPanel;
import net.opanel.deps.gson.Gson;
import net.opanel.utils.Utils;

public abstract class BaseServlet
extends HttpServlet {
    protected final OPanel plugin;

    public BaseServlet(OPanel plugin) {
        this.plugin = plugin;
    }

    protected void sendResponse(HttpServletResponse res, String msg) {
        this.sendResponse(res, 200, msg);
    }

    protected void sendResponse(HttpServletResponse res, HashMap<String, Object> jsonObj) {
        jsonObj.put("code", 200);
        jsonObj.put("error", "");
        this.sendResponse(res, new Gson().toJson(jsonObj));
    }

    protected void sendResponse(HttpServletResponse res, int code) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("code", code);
        switch (code) {
            case 400: {
                obj.put("error", "Bad request");
                break;
            }
            case 401: {
                obj.put("error", "Unauthorized");
                break;
            }
            case 403: {
                obj.put("error", "Forbidden");
                break;
            }
            case 404: {
                obj.put("error", "Not found");
                break;
            }
            case 409: {
                obj.put("error", "Conflict");
                break;
            }
            case 500: {
                obj.put("error", "Server internal error");
            }
        }
        this.sendResponse(res, code, new Gson().toJson(obj));
    }

    protected void sendResponse(HttpServletResponse res, int code, String msg) {
        res.addHeader("X-Powered-By", "OPanel");
        res.setStatus(code);
        res.setContentType("application/json");
        res.setCharacterEncoding("utf-8");
        try (ServletOutputStream os = res.getOutputStream();){
            os.write(msg.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sendContentResponse(HttpServletResponse res, byte[] bytes, String contentType) {
        res.addHeader("X-Powered-By", "OPanel");
        res.setStatus(200);
        res.setContentType(contentType);
        res.setCharacterEncoding("utf-8");
        try (ServletOutputStream os = res.getOutputStream();){
            os.write(bytes);
        }
        catch (IOException e) {
            this.sendResponse(res, 500);
            e.printStackTrace();
        }
    }

    protected <T> T getRequestBody(HttpServletRequest req, Class<T> type) throws IOException {
        try (BufferedReader reader = req.getReader();){
            String line;
            StringBuilder requestBody = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                requestBody.append(line);
            }
            Gson gson = new Gson();
            T t = gson.fromJson(requestBody.toString(), type);
            return t;
        }
    }

    protected <T> T getRequestBody(HttpServletRequest req, Type type) throws IOException {
        try (BufferedReader reader = req.getReader();){
            String line;
            StringBuilder requestBody = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                requestBody.append(line);
            }
            Gson gson = new Gson();
            Object t = gson.fromJson(requestBody.toString(), type);
            return t;
        }
    }

    protected boolean authCookie(HttpServletRequest req) {
        String token = req.getHeader("X-Credential-Token");
        if (token == null) {
            return false;
        }
        String hashedRealKey = Utils.md5(Utils.md5(this.plugin.getConfig().accessKey));
        return token.equals(hashedRealKey);
    }
}

