/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.spigot_1_21_5;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.opanel.common.OPanelWhitelist;
import net.opanel.spigot_1_21_5.Main;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

public class SpigotWhitelist
implements OPanelWhitelist {
    private final Main plugin;
    private final Server server;
    private final Set<OfflinePlayer> whitelist;

    public SpigotWhitelist(Main plugin, Server server, Set<OfflinePlayer> playerList) {
        this.plugin = plugin;
        this.server = server;
        this.whitelist = playerList;
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (OfflinePlayer player : this.whitelist) {
            list.add(player.getName());
        }
        return list;
    }

    @Override
    public List<OPanelWhitelist.OPanelWhitelistEntry> getEntries() {
        ArrayList<OPanelWhitelist.OPanelWhitelistEntry> entries = new ArrayList<OPanelWhitelist.OPanelWhitelistEntry>();
        for (OfflinePlayer player : this.whitelist) {
            entries.add(new OPanelWhitelist.OPanelWhitelistEntry(player.getName(), player.getUniqueId().toString()));
        }
        return entries;
    }

    @Override
    public void write(List<OPanelWhitelist.OPanelWhitelistEntry> entries) {
        List<OPanelWhitelist.OPanelWhitelistEntry> oldEntries = this.getEntries();
        for (OPanelWhitelist.OPanelWhitelistEntry entry : oldEntries) {
            this.remove(entry);
        }
        for (OPanelWhitelist.OPanelWhitelistEntry entry : entries) {
            this.add(entry);
        }
    }

    @Override
    public void add(OPanelWhitelist.OPanelWhitelistEntry entry) {
        if (this.getNames().contains(entry.name)) {
            return;
        }
        this.plugin.runTask(() -> {
            this.server.getOfflinePlayer(UUID.fromString(entry.uuid)).setWhitelisted(true);
            this.server.reloadWhitelist();
        });
    }

    @Override
    public void remove(OPanelWhitelist.OPanelWhitelistEntry entry) {
        if (!this.getNames().contains(entry.name)) {
            return;
        }
        this.plugin.runTask(() -> {
            this.server.getOfflinePlayer(UUID.fromString(entry.uuid)).setWhitelisted(false);
            this.server.reloadWhitelist();
        });
    }
}

