/*
 * Decompiled with CFR 0.152.
 */
package net.opanel.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import net.opanel.ServerType;
import net.opanel.common.OPanelPlayer;
import net.opanel.common.OPanelSave;
import net.opanel.common.OPanelWhitelist;
import net.opanel.utils.Utils;

public interface OPanelServer {
    public static final Path serverPropertiesPath = Paths.get("", new String[0]).resolve("server.properties");

    public ServerType getServerType();

    public byte[] getFavicon();

    public String getMotd();

    public void setMotd(String var1) throws IOException;

    public String getVersion();

    public int getPort();

    public List<OPanelSave> getSaves();

    public OPanelSave getSave(String var1);

    public void saveAll();

    public List<OPanelPlayer> getOnlinePlayers();

    public List<OPanelPlayer> getPlayers();

    public int getMaxPlayerCount();

    public OPanelPlayer getPlayer(String var1);

    public boolean isWhitelistEnabled();

    public void setWhitelistEnabled(boolean var1);

    public OPanelWhitelist getWhitelist();

    public void sendServerCommand(String var1);

    public List<String> getCommands();

    public HashMap<String, Object> getGamerules();

    public void setGamerules(HashMap<String, Object> var1);

    public void reload();

    public void stop();

    public long getIngameTime();

    public static String getPropertiesContent() throws IOException {
        if (!Files.exists(serverPropertiesPath, new LinkOption[0])) {
            throw new IOException("Cannot find server.properties");
        }
        return Utils.readTextFile(serverPropertiesPath);
    }

    public static void writePropertiesContent(String newContent) throws IOException {
        if (!Files.exists(serverPropertiesPath, new LinkOption[0])) {
            throw new IOException("Cannot find server.properties");
        }
        Utils.writeTextFile(serverPropertiesPath, newContent);
    }
}

